#ifndef __ALLEGRO_FLARE_HEADER
#define __ALLEGRO_FLARE_HEADER




#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_acodec.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_color.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_memfile.h>
#include <allegro5/allegro_acodec.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_native_dialog.h>


#include <string>
#include <vector>


#include "bin.h"
#include "bitmap_bin.h"
#include "font_bin.h"
#include "sample_bin.h"

#include "useful.h"
#include "flags.h"
#include "profile_timer.h"

//#include "allegro_flare/camera.h"
#include "display.h"
#include "screen.h"

#include "interpolators.h"
#include "color.h"
#include "motion_control.h"
//#include "allegro_flare/identification.h"

//#include "allegro_flare/render_sample.h"
//#include "allegro_flare/path2d.h"

#include "sound_object.h"
#include "text_object.h"
#include "bitmap_object.h"

//#include "allegro_flare/curl.h"
//#include "allegro_flare/interprocess.h"
//#include "allegro_flare/interprocess_through_files.h"

//#include "allegro_flare/file_path.h"
//#include "allegro_flare/file_path_object.h"

#include <zlib.h>



class af
{
public:

	static ALLEGRO_TEXTLOG *textlog;
	static ALLEGRO_JOYSTICK *joystick; // this needs some revising/updating to allow for hotswapping etc.
	static ALLEGRO_EVENT_QUEUE *event_queue;
	static ALLEGRO_TIMER *primary_timer;
	static bool shutdown_program;
	static Screen *current_screen;
	static ALLEGRO_EVENT *current_event;
	static double time_now; // used to be current_event_time
	static bool initialized;

	static bool key_alt, key_shift, key_ctrl;

	static void initialize(std::string config_filename="");
	static Display *create_display(int width=960, int height=540);
	static Display *create_display(int width, int height, int display_flags);
	static Display *create_display(int width, int height, int display_flags, int adapter);
	static Display *create_display(int width, int height, bool fullscreen);
	static Display *create_display(int width, int height, bool fullscreen, int adapter);
	static Display *create_display(Display::resolution_t resolution);

	static void use_screen(Screen *screen);
	static void run_loop();

	static void open_log_window();
	static void close_log_window();
	static void log(std::string message);
};





#define MASTER_FONT_NAME tostring("geekabyte2.ttf")




#endif