
/*
 *
 *     _______       ___       ____      __       _______
 *    /\  ____\    /|   \     /  __\    /\ \     /\  ____\
 *    \ \ \___/_   ||  _ \   |  /__/____\ \ \    \ \ \___/_
 *     \ \  ____\  || |_\ \  |\ \ /\_  _\\ \ \    \ \  ____\
 *      \ \ \___/_ ||  ___ \ \ \ \\//\ \/ \ \ \____\ \ \___/_
 *       \ \______\||_|__/\_\ \ \ \_\/ |   \ \_____\\ \______\
 *        \/______/|/_/  \/_/  \_\_____/    \/_____/ \/______/
 *
 *
 *    EAGLE
 *    Edgar's Agile Gui Library and Extensions
 *
 *    Copyright 2009-2013+ by Edgar Reynaldo
 *
 *    See EagleLicense.txt for allowed uses of this library.
 *
 */



#include "Eagle/Object.hpp"
#include "Eagle/StringWork.hpp"


#include <iostream>
#include <ostream>

using std::endl;
using std::ostream;



int NextId() {
   static int i = 0;
   return i++;
}



ostream& EagleObject::DescribeTo(ostream& os , Indenter indent) const {
	return os << indent << StringPrintF("EagleObject %c. Addr=%p. Id = %i" , wname.c_str() , this , id) << endl;
}



ostream& operator<<(ostream& os , const EagleObject& obj) {
   return obj.DescribeTo(os);
}



