
/*
 *
 *     _______       ___       ____      __       _______
 *    /\  ____\    /|   \     /  __\    /\ \     /\  ____\
 *    \ \ \___/_   ||  _ \   |  /__/____\ \ \    \ \ \___/_
 *     \ \  ____\  || |_\ \  |\ \ /\_  _\\ \ \    \ \  ____\
 *      \ \ \___/_ ||  ___ \ \ \ \\//\ \/ \ \ \____\ \ \___/_
 *       \ \______\||_|__/\_\ \ \ \_\/ |   \ \_____\\ \______\
 *        \/______/|/_/  \/_/  \_\_____/    \/_____/ \/______/
 *
 *
 *    EAGLE
 *    Edgar's Agile Gui Library and Extensions
 *
 *    Copyright 2009-2013+ by Edgar Reynaldo
 *
 *    See EagleLicense.txt for allowed uses of this library.
 *
 */



#ifndef EagleObject_HPP
#define EagleObject_HPP

#include "Eagle/Logging.hpp"

#include <string>


#include <iostream>
using std::ostream;


int NextId();



class EagleObject {
private :
   int id;
   std::string wname;

public :
   
   EagleObject() : id(NextId()) , wname("Nemo") {}
   EagleObject(std::string name) : id(NextId()) , wname(name) {}
   
   std::string GetName() {return wname;}
   void SetName(std::string newname) {wname = newname;}
   
   virtual ostream& DescribeTo(ostream& os , Indenter indent = Indenter()) const ;
//   virtual ostream& Describe(ostream& os);
   
};

ostream& operator<<(ostream& os , const EagleObject& obj);



#endif // EagleObject_HPP


