

#include "Eagle/Error.hpp"

#include "Eagle/backends/Allegro5/Allegro5Color.hpp"
#include "Eagle/backends/Allegro5/Allegro5EventHandler.hpp"
#include "Eagle/backends/Allegro5/Allegro5Font.hpp"
#include "Eagle/backends/Allegro5/Allegro5GraphicsContext.hpp"
#include "Eagle/backends/Allegro5/Allegro5Image.hpp"

#include "allegro5/allegro.h"
#include "allegro5/allegro_primitives.h"




ALLEGRO_VERTEX MakeAllegro5Vertex(float x , float y , float z , float u , float v , ALLEGRO_COLOR ac) {
	ALLEGRO_VERTEX vtx;
	vtx.x = x;
	vtx.y = y;
	vtx.z = z;
	vtx.u = u;
	vtx.v = v;
	vtx.color = ac;
	return vtx;
}






void Allegro5GraphicsContext::ResetBackBuffer() {
   realbackbuffer = Allegro5Image(al_get_backbuffer(display) , false);
   backbuffer = &realbackbuffer;
   SetDrawingTarget(backbuffer);
}



Allegro5GraphicsContext::Allegro5GraphicsContext() :
      EagleGraphicsContext(),
      display(0),
      realbackbuffer()
{}



Allegro5GraphicsContext::Allegro5GraphicsContext(int width , int height , int flags) :
      EagleGraphicsContext(),
      display(0),
      realbackbuffer()
{
   Create(width , height , flags);
}



Allegro5GraphicsContext::~Allegro5GraphicsContext() {
   Destroy();
}



// creation/destruction
bool Allegro5GraphicsContext::Create(int width , int height , int flags) {
   Destroy();
   
   al_set_new_display_flags(flags);
   display = al_create_display(width,height);
   if (!display) {return false;}
   scrw = width;
   scrh = height;
   
   ResetBackBuffer();

   return true;
}



bool Allegro5GraphicsContext::Valid() {
   return (display);
}



void Allegro5GraphicsContext::Destroy() {
   images.FreeAll();
   if (display) {
      al_destroy_display(display);
      display = 0;
   }
}



// clears target bitmap
void Allegro5GraphicsContext::Clear(EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_clear_to_color(ac);
}



// basic drawing operations
void Allegro5GraphicsContext::PutPixel(int x , int y , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_put_pixel(x,y,ac);
}



void Allegro5GraphicsContext::DrawLine(int x1 , int y1 , int x2 , int y2 , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_line(x1 + 0.5f , y1 + 0.5f , x2 + 0.5f , y2 + 0.5f , ac , 1.0);
}



void Allegro5GraphicsContext::DrawRectangle(int x , int y , int w , int h , int thickness , EagleColor c) {
   float fx = x;
   float fy = y;
   float fw = w;
   float fh = h;
   float fthickness = thickness;
   ALLEGRO_COLOR ac = GetAllegroColor(c);

   const float onehalf = 1.0f/2.0f;
   al_draw_rectangle( fx + onehalf , fy + onehalf , fx + fw - onehalf , fy + fh - onehalf , ac , fthickness);
}



void Allegro5GraphicsContext::DrawFilledRectangle(int x , int y , int w , int h , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_rectangle(x , y , x + w , y + h , ac);
}



void Allegro5GraphicsContext::DrawRoundedRectangle(int x , int y , int w , int h , int rx , int ry , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_rounded_rectangle(x , y , x + w , y + h , rx , ry , ac , 1.0);
}



void Allegro5GraphicsContext::DrawFilledRoundedRectangle(int x , int y , int w , int h , int rx , int ry , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_filled_rounded_rectangle(x , y , x + w , y + h , rx , ry , ac);
}



void Allegro5GraphicsContext::DrawCircle(int cx , int cy , int radius , int thickness , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_circle(cx + 0.5f , cy + 0.5f , radius , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledCircle(int cx , int cy , int radius , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_circle(cx + 0.5f , cy + 0.5f , radius , ac);
}



void Allegro5GraphicsContext::DrawEllipse(int cx , int cy , int rx , int ry , int thickness , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_ellipse(cx + 0.5f , cy + 0.5f , rx , ry , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledEllipse(int cx , int cy , int rx , int ry , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_filled_ellipse(cx + 0.5f , cy + 0.5f , rx , ry , ac);
}



void Allegro5GraphicsContext::DrawTriangle(int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int thickness , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_triangle(x1 + 0.5f , y1 + 0.5f , x2 + 0.5f , y2 + 0.5f , x3 + 0.5f , y3 + 0.5f , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledTriangle(int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_triangle(x1 + 0.5f , y1 + 0.5f , x2 + 0.5f , y2 + 0.5f , x3 + 0.5f , y3 + 0.5f , ac);
}



// precise drawing operations
void Allegro5GraphicsContext::PutPixel(float x , float y , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_pixel(x,y,ac);
}



void Allegro5GraphicsContext::DrawLine(float x1 , float y1 , float x2 , float y2 , float thickness , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_line(x1 , y1 , x2 , y2 , ac , thickness);
}



void Allegro5GraphicsContext::DrawRectangle(float x , float y , float w , float h , float thickness , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_rectangle(x , y , x + w , x + h , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledRectangle(float x , float y , float w , float h , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_rectangle(x , y , x + w , x + h , ac);
}



void Allegro5GraphicsContext::DrawRoundedRectangle(float x , float y , float w , float h , float rx , float ry , float thickness , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_rounded_rectangle(x , y , x + w , y + h , rx , ry , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledRoundedRectangle(float x , float y , float w , float h , float rx , float ry , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_filled_rounded_rectangle(x , y , x + w , y + h , rx , ry , ac);
}



void Allegro5GraphicsContext::DrawCircle(float cx , float cy , float radius , float thickness , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_circle(cx , cy , radius , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledCircle(float cx , float cy , float radius , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_circle(cx , cy , radius , ac);
}



void Allegro5GraphicsContext::DrawEllipse(float cx , float cy , float rx , float ry , float thickness , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_ellipse(cx , cy , rx , ry , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledEllipse(float cx , float cy , float rx , float ry , EagleColor c) {
	ALLEGRO_COLOR ac = GetAllegroColor(c);
	al_draw_filled_ellipse(cx , cy , rx , ry , ac);
}



void Allegro5GraphicsContext::DrawTriangle(float x1 , float y1 ,
                                           float x2 , float y2 ,
                                           float x3 , float y3 ,
                                           float thickness , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_triangle(x1 , y1 , x2 , y2 , x3 , y3 , ac , thickness);
}



void Allegro5GraphicsContext::DrawFilledTriangle(float x1 , float y1 , float x2 , float y2 , float x3 , float y3 , EagleColor c) {
   ALLEGRO_COLOR ac = GetAllegroColor(c);
   al_draw_filled_triangle(x1 , y1 , x2 , y2 , x3 , y3 , ac);
}



void Allegro5GraphicsContext::DrawShadedRectangle(const Rectangle* r , EagleColor tl , EagleColor tr , EagleColor br , EagleColor bl) {
	EAGLE_ASSERT(r);
	float lx = r->X();
	float rx = r->X() + r->W();
	float ty = r->Y();
	float by = r->Y() + r->H();
	DrawShadedQuad(lx,ty,tl , rx,ty,tr , rx,by,br , lx,by,bl);
}



void Allegro5GraphicsContext::DrawShadedQuad(float x1 , float y1 , EagleColor c1 ,
															float x2 , float y2 , EagleColor c2 ,
															float x3 , float y3 , EagleColor c3 , 
															float x4 , float y4 , EagleColor c4) {
	ALLEGRO_VERTEX vtx[4] = {
		MakeAllegro5Vertex(x1 , y1 , 0.0 , 0.0 , 0.0 , GetAllegroColor(c1)),
		MakeAllegro5Vertex(x2 , y2 , 0.0 , 0.0 , 0.0 , GetAllegroColor(c2)),
		MakeAllegro5Vertex(x3 , y3 , 0.0 , 0.0 , 0.0 , GetAllegroColor(c3)),
		MakeAllegro5Vertex(x4 , y4 , 0.0 , 0.0 , 0.0 , GetAllegroColor(c4))
	};
	
	al_draw_prim(vtx , 0 , 0 , 0 , 4 , ALLEGRO_PRIM_TRIANGLE_FAN);
}



// image drawing operations
void Allegro5GraphicsContext::Draw(EagleImage* img , float x , float y , int flags) {
   ALLEGRO_BITMAP* bmp = GetAllegroBitmap(img);
   EAGLE_ASSERT(bmp);
   al_draw_bitmap(bmp , x , y , flags);
}



void Allegro5GraphicsContext::DrawRegion(EagleImage* img , Rectangle src , float x , float y , int flags) {
   ALLEGRO_BITMAP* bmp = GetAllegroBitmap(img);
   EAGLE_ASSERT(bmp);
//void al_draw_bitmap_region(ALLEGRO_BITMAP *bitmap, float sx, float sy, float sw, float sh, float dx, float dy, int flags);
   al_draw_bitmap_region(bmp , src.X() , src.Y() , src.W() , src.H() , x , y , flags);
}



void Allegro5GraphicsContext::DrawStretchedRegion(EagleImage* img ,
                                                  float sx , float sy , float sw , float sh ,
                                                  float dx , float dy , float dw , float dh ,
                                                  int flags) {
   ALLEGRO_BITMAP* bmp = GetAllegroBitmap(img);
   EAGLE_ASSERT(bmp);
   al_draw_scaled_bitmap(bmp , sx , sy , sw , sh , dx , dy , dw , dh , flags);
}



/**
TODO TODO TODO ADD THIS FUNCTION FINISH IT BIHATCHIAN BIYATCH BITCH FACE
void Allegro5GraphicsContext::Draw(EagleImage* src , EagleDrawingInfo info) {

//   bool use_any;
//   bool use_region;
//   bool use_scale;
//   bool use_resize;// if false, destination point will be used, which is default
//   bool use_rotate;
//   bool use_tint;


   ALLEGRO_COLOR tint = GetAllegroColor(info.tint);
   Allegro5Image* a5img = dynamic_cast<Allegro5Image*>(src);
   EAGLE_ASSERT(a5img);
   ALLEGRO_BITMAP* bmp = a5img->AllegroBitmap();
   EAGLE_ASSERT(bmp);

   if (info.use_any) {

// Drawing operations
//
//    al_draw_bitmap_region
//    al_draw_tinted_bitmap_region
//    al_draw_tinted_scaled_rotated_bitmap_region
//
//    al_draw_bitmap
//    al_draw_scaled_bitmap
//    al_draw_tinted_bitmap
//    al_draw_rotated_bitmap
//
//    al_draw_tinted_rotated_bitmap
//    al_draw_scaled_rotated_bitmap
//    al_draw_tinted_scaled_rotated_bitmap
//    al_draw_tinted_scaled_bitmap
//

      if (info.use_region) {
         // Using source region
         if (use_resize) {
            // simple stretch blit
            if (tint) {
               // tint,resize,region

//void al_draw_tinted_scaled_bitmap(ALLEGRO_BITMAP *bitmap,
//   ALLEGRO_COLOR tint,
//   float sx, float sy, float sw, float sh,
//   float dx, float dy, float dw, float dh, int flags)

               al_draw_tinted_scaled_bitmap(bmp , tint , info.region.x , info.region.y , info.region.w , info.region.h,
                                            info.resize.dx , info.resize.dy , info.resize.dw , info.resize.dh , info.flags);
            }
            else {
               
            }
         }
         else if (use_rotate) {
            float xscale = 1.0f;
            float yscale = 1.0f;
            if (use_scale) {
               xscale = info.scale.x;
               yscale = info.scale.y;
            }
         }
         
         
      }
      else {
         
      }
   }
   
}
*/






void Allegro5GraphicsContext::DrawTextString(EagleFont* font , std::string s , float x , float y , EagleColor c ,
                                             TEXT_HDRAWING_FLAGS halign , TEXT_VDRAWING_FLAGS valign) {
   Allegro5Font* a5font = dynamic_cast<Allegro5Font*>(font);
   EAGLE_ASSERT(a5font);
   ALLEGRO_FONT* f = a5font->AllegroFont();
   EAGLE_ASSERT(f);
   int textwidth = al_get_text_width(f , s.c_str());
   int textheight = al_get_font_line_height(f);
   if (halign == DRAW_TEXT_CENTER) {x -= textwidth/2;}
   if (halign == DRAW_TEXT_RIGHT) {x -= textwidth;}
   if (valign == DRAW_TEXT_VCENTER) {y -= textheight/2;}
   if (valign == DRAW_TEXT_BOTTOM) {y -= textheight;}
//void al_draw_text(const ALLEGRO_FONT *font,
//   ALLEGRO_COLOR color, float x, float y, int flags,
//   char const *text) 
   al_draw_text(f , GetAllegroColor(c) , x , y , 0 , s.c_str());
}



// getters
EagleImage* Allegro5GraphicsContext::GetBackBuffer() {
   EAGLE_ASSERT(backbuffer);
   return backbuffer;
}



EagleImage* Allegro5GraphicsContext::GetScreen() {
   return 0;
}



EagleImage* Allegro5GraphicsContext::GetDrawingTarget() {
   return drawing_target;
}



// utilities
void Allegro5GraphicsContext::FlipDisplay() {
   al_flip_display();
   ResetBackBuffer();
}



void Allegro5GraphicsContext::HoldDrawing() {
   al_hold_bitmap_drawing(true);
}



void Allegro5GraphicsContext::ReleaseDrawing() {
   al_hold_bitmap_drawing(false);
}



void Allegro5GraphicsContext::SetDrawingTarget(EagleImage* dest) {
   EAGLE_ASSERT(dest);
   Allegro5Image* a5img = dynamic_cast<Allegro5Image*>(dest);
   EAGLE_ASSERT(a5img);
   ALLEGRO_BITMAP* a5bmp = a5img->AllegroBitmap();
   EAGLE_ASSERT(a5bmp);
   al_set_target_bitmap(a5bmp);
   drawing_target = dest;
   
}



EagleImage* Allegro5GraphicsContext::EmptyImage() {
   EagleImage* img = new Allegro5Image();
   images.Add(img);
   return img;
}



EagleImage* Allegro5GraphicsContext::CloneImage(EagleImage* img) {
   Allegro5Image* newimg = new Allegro5Image();
   newimg->Allocate(img->W() , img->H() , img->ImageType());
   /// TODO Set blender here
   PushDrawingTarget(newimg);
   /// TODO Reset blending here
   Draw(img , 0.0f , 0.0f);
   
   PopDrawingTarget();
   
   images.Add(newimg);
   return newimg;
}



// image creation / loading / sub division
EagleImage* Allegro5GraphicsContext::CreateImage(int width , int height , IMAGE_TYPE type) {
   EagleImage* eagle_image = new Allegro5Image(width , height , type);
   images.Add(eagle_image);
   return eagle_image;
}



EagleImage* Allegro5GraphicsContext::LoadImageFromFile(std::string file , IMAGE_TYPE type) {
   EagleImage* eagle_image = new Allegro5Image(file , type);
   images.Add(eagle_image);
   return eagle_image;
}



EagleImage* Allegro5GraphicsContext::CreateSubImage(EagleImage* parent , int x , int y , int width , int height) {
   EagleImage* eagle_image = new Allegro5Image(parent , x , y , width , height);
   images.Add(eagle_image);
   return eagle_image;
}



EagleFont* Allegro5GraphicsContext::LoadFont(std::string file , int height , int flags , IMAGE_TYPE type) {
   EagleFont* eagle_font = new Allegro5Font(file , height , flags , type);
   fonts.Add(eagle_font);
   
   return eagle_font;
}


/*
void Allegro5GraphicsContext::ReadEvents() {
   ALLEGRO_EVENT allegro_event;
   while (al_get_next_event(queue , &allegro_event)) {
      PostEvent(GetEagleEvent(allegro_event));
   }
}
*/


void Allegro5GraphicsContext::RegisterDisplayInput(EagleEventHandler* eagle_handler) {
   EAGLE_ASSERT(eagle_handler);
   Allegro5EventHandler* allegro_handler = dynamic_cast<Allegro5EventHandler*>(eagle_handler);
   EAGLE_ASSERT(allegro_handler);
   ALLEGRO_EVENT_QUEUE* allegro_queue = allegro_handler->AllegroQueue();
   if (display) {
      al_register_event_source(allegro_queue , al_get_display_event_source(display));
   }
}



void Allegro5GraphicsContext::ShowMouse() {
   if (!display) {
      OutputLog() << "Allegro5GraphicsContext::ShowMouse() : Display not valid." << std::endl;
      return;
   }
   al_show_mouse_cursor(display);
}




