

#include "Eagle/Gui/TestWidget.hpp"
#include "Eagle/InputHandler.hpp"

#include <cstdlib>

int TestWidget::PrivateHandleEvent(EagleEvent e) {
   (void)e;
   return DIALOG_OKAY;
}



void TestWidget::PrivateDisplay(EagleGraphicsContext* win , int xpos , int ypos) {

   Rectangle r = area.InnerArea();
   r.MoveBy(xpos,ypos);
   win->DrawFilledRectangle(r , bgcolor);

   ClearRedrawFlag();
}



int TestWidget::CheckInputs() {
   if (input_mouse_press(LMB) && area.InnerArea().Contains(mouse_x , mouse_y)) {
      RandomizeColor();
   }
   return DIALOG_OKAY;
}






int TestWidget::Update(double tsec) {
   (void)tsec;
   FadeColor();
   return DIALOG_OKAY;
}



void TestWidget::RandomizeColor() {
   bgcolor = EagleColor(rand()%255 , rand()%255 , rand()%255);
   SetRedrawFlag();
}



void TestWidget::FadeColor() {
   bgcolor.SetColor(bgcolor.r - 1 , bgcolor.g - 1 , bgcolor.b - 1);
   SetRedrawFlag();
}



