
/*
 *
 *     _______       ___       ____      __       _______
 *    /\  ____\    /|   \     /  __\    /\ \     /\  ____\
 *    \ \ \___/_   ||  _ \   |  /__/____\ \ \    \ \ \___/_
 *     \ \  ____\  || |_\ \  |\ \ /\_  _\\ \ \    \ \  ____\
 *      \ \ \___/_ ||  ___ \ \ \ \\//\ \/ \ \ \____\ \ \___/_
 *       \ \______\||_|__/\_\ \ \ \_\/ |   \ \_____\\ \______\
 *        \/______/|/_/  \/_/  \_\_____/    \/_____/ \/______/
 *
 *
 *    EAGLE
 *    Edgar's Agile Gui Library and Extensions
 *
 *    Copyright 2009-2014+ by Edgar Reynaldo
 *
 *    See EagleLicense.txt for allowed uses of this library.
 *
 */



#include "Eagle/Gui/Layout/PinLayout.hpp"



void PinLayout::ReserveSlots(int nslots) {
   Layout::ReserveSlots(nslots);
   layout_rectangles.resize(wchildren.size() , LayoutRectangle(0,0,1,1));
}



void PinLayout::RepositionAllChildren() {
   for (unsigned int i = 0 ; i < wchildren.size() ; ++i) {
      RepositionChild(i);
   }
}



void PinLayout::RepositionChild(int slot) {
   EAGLE_ASSERT(slot >= 0 && slot < (int)wchildren.size());
   LayoutRectangle layout_rect = layout_rectangles[slot];
   WidgetBase* widget = wchildren[slot];
   widget->SetArea(LayoutArea(area.InnerArea() , layout_rect));
}
   


