
/*
 *
 *     _______       ___       ____      __       _______
 *    /\  ____\    /|   \     /  __\    /\ \     /\  ____\
 *    \ \ \___/_   ||  _ \   |  /__/____\ \ \    \ \ \___/_
 *     \ \  ____\  || |_\ \  |\ \ /\_  _\\ \ \    \ \  ____\
 *      \ \ \___/_ ||  ___ \ \ \ \\//\ \/ \ \ \____\ \ \___/_
 *       \ \______\||_|__/\_\ \ \ \_\/ |   \ \_____\\ \______\
 *        \/______/|/_/  \/_/  \_\_____/    \/_____/ \/______/
 *
 *
 *    EAGLE
 *    Edgar's Agile Gui Library and Extensions
 *
 *    Copyright 2009-2013+ by Edgar Reynaldo
 *
 *    See EagleLicense.txt for allowed uses of this library.
 *
 */



#ifndef EagleGuiWidgetArea_HPP
#define EagleGuiWidgetArea_HPP


#include "Eagle/Area.hpp"
#include "Eagle/Image.hpp"




enum MARGIN_HCELL {
	MARGIN_HCELL_LEFT = 0,
	MARGIN_HCELL_CENTER = 1,
	MARGIN_HCELL_RIGHT = 2
};
enum MARGIN_VCELL {
	MARGIN_VCELL_TOP = 0,
	MARGIN_VCELL_CENTER = 1,
	MARGIN_VCELL_BOTTOM = 2
};

class WidgetArea {

private :

	// margins on left right top and bottom - 9 cells
	int mleft;
	int mright;
	int mtop;
	int mbot;
	
	Rectangle outer_area;
	Rectangle inner_area;

	EagleImage* cell_images[3][3];

public :

	WidgetArea();

	Rectangle OuterArea() const {return outer_area;}
	Rectangle InnerArea() const {return inner_area;}
	int       W() const {return outer_area.W();}
	int       H() const {return outer_area.H();}
	Rectangle   GetCellRectangle (MARGIN_HCELL hcell , MARGIN_VCELL vcell) const ;
	EagleImage* GetCellImage     (MARGIN_HCELL hcell , MARGIN_VCELL vcell) const ;
	
	void Paint(EagleGraphicsContext* win , MARGIN_HCELL hcell , MARGIN_VCELL vcell, EagleColor col , int x , int y) const ;
	void PaintAll(EagleGraphicsContext* win , EagleColor col , int x , int y) const;
	void PaintImage(EagleGraphicsContext* win , MARGIN_HCELL hcell , MARGIN_VCELL vcell , int x , int y , int flags) const;
	void PaintImages(EagleGraphicsContext* win , int x , int y) const;
	void SetImage(MARGIN_HCELL hcell , MARGIN_VCELL vcell , EagleImage* img);

	void SetOuterPos(int xpos , int ypos);
	void SetOuterDim(unsigned int width , unsigned int height);
	void SetOuterArea(Rectangle r);
	void SetOuterArea(int xpos , int ypos , unsigned int width , unsigned int height);

	void SetInnerPos(int xpos , int ypos);
	void SetInnerDim(unsigned int width , unsigned int height);
	void SetInnerArea(Rectangle r);
	void SetInnerArea(int xpos , int ypos , unsigned int width , unsigned int height);

	void SetMarginsExpandFromInner(int left , int right , int top , int bottom);/// Changes position!!!
	void SetMarginsContractFromOuter(int left , int right , int top , int bottom);/// Make room in outer area first!!!
	
	int MaxHMargin() const {return outer_area.W() - inner_area.W();}
	int MaxVMargin() const {return outer_area.H() - inner_area.H();}
	
	int MLeft()  const {return mleft;}
	int MRight() const {return mright;}
	int MTop()   const {return mtop;}
	int MBot()   const {return mbot;}

	int OuterX()   const {return outer_area.X();}
	int OuterY()   const {return outer_area.Y();}
	int OuterBRX() const {return outer_area.BRX();}
	int OuterBRY() const {return outer_area.BRY();}
	
	int InnerX()   const {return inner_area.X();}
	int InnerY()   const {return inner_area.Y();}
	int InnerBRX() const {return inner_area.BRX();}
	int InnerBRY() const {return inner_area.BRY();}

   ostream& DescribeTo(ostream& os , Indenter indent = Indenter()) const ;

};





#endif // EagleGuiWidgetArea_HPP
