#include <allegro5/allegro.h>
#include <allegro5/allegro_memfile.h>
#include <stdio.h>
#include <stdlib.h>


#define DISPLAY_W 640
#define DISPLAY_H 480

#define SKIP_W 16
#define SKIP_H 16

void display_bitmap(ALLEGRO_BITMAP * bmp, int x, int y, double delay) {
  al_clear_to_color(al_map_rgb(0, 0, 0));
  al_draw_bitmap(bmp, (double)x, (double)y, 0);
  al_flip_display();
  al_rest(delay);
}

bool save_sub_bitmap(ALLEGRO_BITMAP * sub, 
                     int x, int y, int slice_w, int slice_h, 
                     const char * prefix) {
  int size;
  void * buffer;
  int real_size;
  ALLEGRO_FILE * memfile;
        
  if(!sub) {
    fprintf(stderr, "Could not create sub bitmap!\n");
    return false;
  }
  /* Allocate a buffer that should always be too big.*/
  size      = slice_w * slice_h * 4 * 2;
  buffer    = calloc(size, 1);
  real_size = 0;
  if(!buffer) {
    fprintf(stderr, "Could not allocate buffer!\n");
    return false;
  }
  
  /* Open memfile. */
  memfile = al_open_memfile(buffer, size, "rw");
  if(!memfile) {
    fprintf(stderr, "Failed to open memfile!\n"); 
  } else {
    /* save the bitmap into the memfile. */
    al_save_bitmap_f(memfile, ".bmp", sub);
    /* Get the real size of the bitmap. */
    real_size = al_ftell(memfile);
    if(real_size < 1) {
      fprintf(stderr, "Real size is too small!\n");
    } else {
      /* now, buffer contains the correct bitmap data. Save that to a file
       * (but if could be stored into sqlite as well, if needed). */
      FILE * output;
      char filename[255];
      sprintf(filename, "%.16s_%d_%d.bmp\0", prefix, (int)(x / slice_w) + 1, (int)(y/slice_h) + 1);
      output = fopen(filename, "w");
      if(!output) {
        fprintf(stderr, "Could not open output file!\n");
      } else {
        fwrite(buffer, size, 1, output);
        fclose(output);
      }
   }
   al_fclose(memfile);
  }
  free(buffer);
}


bool split_and_save_bitmap(ALLEGRO_BITMAP * input, int slice_w, int slice_h, const char * prefix) {
  int x, y;
  for(y = 0; y < al_get_bitmap_height(input) ; y += slice_h) {
    for(x = 0; x < al_get_bitmap_width(input)  ; x += slice_w) {
      /* create the sub bitmap */
      ALLEGRO_BITMAP * sub = al_create_sub_bitmap(input, x, y, slice_w, slice_h);
      /* display it, then save it, and then clean up. */
      display_bitmap(sub, x, y, 0.1); 
      save_sub_bitmap(sub, x, y, slice_w, slice_h, prefix);
      al_destroy_bitmap(sub);
    }
  }

}


int main(int argc, char ** argv) {
  ALLEGRO_DISPLAY * display = NULL;
  ALLEGRO_BITMAP  * input   = NULL;
  
  if (!al_init()) { 
    fprintf(stderr, "Failed to initialize allegro!\n");
    return 1;
  }
  
  if (!al_init_image_addon()) {
    fprintf(stderr, "Failed to initialize image addon!\n");
    return 2;
  }
  
  display = al_create_display(DISPLAY_W, DISPLAY_H);
  if(!display) {
    fprintf(stderr, "Failed to create display!\n");
    return 3;
  }
  
  input = al_load_bitmap("input.png");
  if (!input) {
    fprintf(stderr, "Failed to load input!\n");
    al_destroy_display(display);
    return 4;
  }
  /* Display loaded bitmap */
  display_bitmap(input, 0.0, 0.0, 0.5);
  /* Now split and save it. */
  split_and_save_bitmap(input, SKIP_W, SKIP_H, "output");

  al_destroy_display(display);
}

