// coded by user http://www.allegro.cc/members/altalena on December 1, 2012
// see copyright documentation for disclaimer and attribution

#include <stdio.h>
#include <cmath>
#include <allegro5/allegro.h>
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_opengl.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <GL/glu.h>
#include "MTwister.h"
#include "PNoise.h"
#define M_2PIE 6.28318530717958647692528676656
#define NUMBEROFSTARS 10000 // up to a million stars

int  fast_floor(double x)
{
    return ( ((x)>0) ? ((int)x) : ((int)x-1 ) );
}

const float FPS = 30;
enum MYKEYS
{
    KEY_W, KEY_S, KEY_A, KEY_D, KEY_R, KEY_F, KEY_P, KEY_LCTRL, KEY_SPACE, KEY_ALT, KEY_ESC
};

ALLEGRO_DISPLAY *display = NULL;
ALLEGRO_DISPLAY_MODE disp_data;
ALLEGRO_EVENT_QUEUE *event_queue = NULL;
ALLEGRO_TIMER *timer = NULL;
float cursor_x = 0;
float cursor_y = 0;
float rat_dx = 0;
float rat_dy = 0;
int y_axis = 1;
int gamepaused = 1;
bool key[11] = { false, false, false, false, false, false, false, false, false, false, false };
bool redraw = true;
bool doexit = false;
double stars[NUMBEROFSTARS][3];
double stars_brightness[NUMBEROFSTARS][2];
bool compatibility = 0; //               ------------------ video compatibility mode for analog monitors
const int w3d = 120; // width            ------------------ view distance*2
const int s3d = w3d; // steps
double t3d[2][s3d+1][s3d+1][9]; // levels of detail, x, y, xyz and rgb for nw and se triangles
float e3d[6] = { 0, 0, 0, 0, 0, 0 };  // x and y for seam in toroidal terrain buffer, old eye[], (new)-(old)
float c3d[12] = { 0.5, 0.5, 0.25, 0.5, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.75 };
float ambient_l = 0.64;
double phi = 100.0;
double theta = 0.0;
char wire_mode = 0;
float looking_at[6] = {-0.0f,1.0f,9.0f,-0.0f,1.0f,9.0f};
float aim_spread = 0.0f;
float eye[3] = {0.0f,0.0f,9.0f};
float cam_speed = 12.0;
int slow_speed = 0;

int main(int argc, char **argv)
{
    if(!al_init())
    {
        fprintf(stderr, "failed to initialize allegro!\n");
        getchar();
        return -1;
    }

    if(!al_install_keyboard())
    {
        fprintf(stderr, "failed to initialize the keyboard!\n");
        getchar();
        return -1;
    }

    if(!al_install_mouse())
    {
        fprintf(stderr, "failed to initialize the mouse!\n");
        getchar();
        return -1;
    }

    timer = al_create_timer(1.0 / FPS);
    if(!timer)
    {
        fprintf(stderr, "failed to create timer!\n");
        getchar();
        return -1;
    }

    int d_pixels[al_get_num_display_modes()];
    for (int n = 0; n < al_get_num_display_modes() - 1; n++)
    {
        al_get_display_mode(n, &disp_data);
        d_pixels[n] = disp_data.height*disp_data.width;
    }
    int d_index = 0;
    int old_d_var = d_pixels[0];
    for (int n = 0; n < al_get_num_display_modes() - 1; n++)
    {
        if(d_pixels[n]>old_d_var) d_index = n;
        old_d_var = d_pixels[n];
    }
    al_get_display_mode(d_index, &disp_data);
    al_set_new_display_flags(ALLEGRO_OPENGL|ALLEGRO_FULLSCREEN);
    if (compatibility)
    {
        display = al_create_display(800, 600);
    }
    else
    {
        display = al_create_display(disp_data.width, disp_data.height);
    }
    if(!display)
    {
        fprintf(stderr, "failed to create display!\n");
        getchar();
        al_destroy_timer(timer);
        return -1;
    }
    al_hide_mouse_cursor(display);
    int d_w = al_get_display_width(display);
    int d_h = al_get_display_height(display);
    float aspect_ratio = 1.0*d_w/d_h;

    if(!al_init_primitives_addon())
    {
        fprintf(stderr, "failed to initialize primitives!\n");
        getchar();
        al_destroy_display(display);
        al_destroy_timer(timer);
        return -1;
    }

    al_init_font_addon();
    al_init_ttf_addon();
    ALLEGRO_FONT *font_tt = al_load_ttf_font("VeraMono.ttf",int(24.0*d_h/1080.0),0 );

    al_set_target_bitmap(al_get_backbuffer(display));

    event_queue = al_create_event_queue();
    if(!event_queue)
    {
        fprintf(stderr, "failed to create event_queue!\n");
        al_destroy_display(display);
        al_destroy_timer(timer);
        return -1;
    }

    al_register_event_source(event_queue, al_get_display_event_source(display));
    al_register_event_source(event_queue, al_get_timer_event_source(timer));
    al_register_event_source(event_queue, al_get_keyboard_event_source());
    al_register_event_source(event_queue, al_get_mouse_event_source());

    al_clear_to_color(al_map_rgb(0,0,0));
    al_flip_display();

    al_start_timer(timer);

    for (int i = 0; i <= NUMBEROFSTARS-1; i += 1)
    {
        double s_azimuth = M_2PIE*mers_genrand_real1()+0.31416;
        double s_elevation = acosf(mers_genrand_real1()*2.0-1.0)-ALLEGRO_PI/2.0;
        double s_range = pow(1.06,mers_genrand_real1()*100.0)-1.06+10.0;
        //if (s_range < 1.0) s_range = sqrt( mers_genrand_real1()+0.001 );
        stars [i][0] = (sinf(s_azimuth)*cosf(s_elevation)*s_range)+10.0;//*32000;//i;
        stars [i][1] = (cosf(s_azimuth)*cosf(s_elevation)*s_range)+10.0;//*32000;//i;
        stars [i][2] = (sinf(s_elevation)*s_range)/2.0+10.0;//*16000;//i;
        stars_brightness [i][0] = mers_genrand_real1();
    }
//    ALLEGRO_BITMAP *image = NULL;
    //al_set_new_bitmap_flags(ALLEGRO_MEMORY_BITMAP);
//    image = al_load_bitmap("noise.png");
//    GLuint texture = al_get_opengl_texture(image);
    //al_set_new_bitmap_flags(ALLEGRO_VIDEO_BITMAP);

    long int timercount = 0;
    while(!doexit)
    {
        ALLEGRO_EVENT ev;
        al_wait_for_event(event_queue, &ev);

        if(ev.type == ALLEGRO_EVENT_TIMER)
        {
            timercount++;
            if(gamepaused==0)
            {
                phi -= rat_dx/4.0;
                theta += y_axis*rat_dy/4.0;
                if(theta > 99.75)
                {
                    theta = 99.75;
                }
                else if(theta < -99.75)
                {
                    theta = -99.75;
                }
                if(phi > 400.0)                     // wraps camera azimuth
                {
                    phi -= 400.0;
                }
                else if(phi < 0.0)
                {
                    phi += 400.0;
                }
                char diagonal_movement = 1;
                if (key[KEY_W])
                {
                    diagonal_movement += 1;
                }
                if (key[KEY_S])
                {
                    diagonal_movement += 1;
                }
                if (key[KEY_A])
                {
                    diagonal_movement += 1;
                }
                if (key[KEY_D])
                {
                    diagonal_movement += 1;
                }
                float cam_speed_adjusted = cam_speed*(1.0-0.2928932188134524*(diagonal_movement%2));
                if (key[KEY_ALT]) cam_speed_adjusted*=6.25;
                if (key[KEY_LCTRL]) cam_speed_adjusted*=0.064;
                if (slow_speed) cam_speed_adjusted*=0.004096;

                if (key[KEY_W])
                {
                    eye[0] -= cam_speed_adjusted * sin((phi - 100.0)*M_2PIE/400.0) * cos(theta*M_2PIE/400.0) / FPS;
                    eye[1] += cam_speed_adjusted * cos((phi - 100.0)*M_2PIE/400.0) * cos(theta*M_2PIE/400.0) / FPS;
                    eye[2] += cam_speed_adjusted * sin(theta*M_2PIE/400.0) / FPS;
                }
                if (key[KEY_S])
                {
                    eye[0] += cam_speed_adjusted * sin((phi - 100.0)*M_2PIE/400.0) * cos(theta*M_2PIE/400.0) / FPS;
                    eye[1] -= cam_speed_adjusted * cos((phi - 100.0)*M_2PIE/400.0) * cos(theta*M_2PIE/400.0) / FPS;
                    eye[2] -= cam_speed_adjusted * sin(theta*M_2PIE/400.0) / FPS;
                }
                if (key[KEY_A])
                {
                    eye[0] -= cam_speed_adjusted * sin(phi*M_2PIE/400.0) / FPS;
                    eye[1] += cam_speed_adjusted * cos(phi*M_2PIE/400.0) / FPS;
                }
                if (key[KEY_D])
                {
                    eye[0] += cam_speed_adjusted * sin(phi*M_2PIE/400.0) / FPS;
                    eye[1] -= cam_speed_adjusted * cos(phi*M_2PIE/400.0) / FPS;
                }
            }

            looking_at[0]=eye[0]+1.0*cos(phi*M_2PIE/400.0)*cos(theta*M_2PIE/400.0);
            looking_at[1]=eye[1]+1.0*sin(phi*M_2PIE/400.0)*cos(theta*M_2PIE/400.0);
            looking_at[2]=eye[2]+1.0*sin(theta*M_2PIE/400.0);
            aim_spread += pow(pow((looking_at[3]-looking_at[0]),2.0)+pow((looking_at[4]-looking_at[1]),2.0)+pow((looking_at[5]-looking_at[2]),2.0),0.5);
            aim_spread*=0.9;
            for (int n = 0; n < 3; n++)
            {
                looking_at[3+n]=looking_at[n];
            }

            redraw = true;
            rat_dx = 0;
            rat_dy = 0;
        }
        else if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE)
        {
            break;
        }
        else if(ev.type == ALLEGRO_EVENT_MOUSE_AXES                 // mouse input
                || ev.type == ALLEGRO_EVENT_MOUSE_ENTER_DISPLAY)
        {
            cursor_x = ev.mouse.x;
            cursor_y = ev.mouse.y;
            rat_dx += ev.mouse.dx;
            rat_dy += ev.mouse.dy;
        }
        if(ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_DOWN)     // menu click detection
        {
            if (gamepaused == 1)
            {
                if ( cursor_x>=d_w*0.35 && cursor_x<=d_w*0.65 && cursor_y>=d_h*0.61 && cursor_y<=d_h*0.69 )
                {
                    doexit = true;
                }
                if ( cursor_x>=d_w*(0.65-.07*d_h/d_w) && cursor_y>=d_h*0.52 &&
                        cursor_x<=d_w*(0.65-.01*d_h/d_w) && cursor_y<=d_h*0.58 )
                {
                    if (y_axis==1) y_axis=-1;
                    else y_axis=1;
                }
                if ( cursor_x>=d_w*0.35 && cursor_x<=d_w*0.65 && cursor_y>=d_h*0.41 && cursor_y<=d_h*0.49 )
                {
                    gamepaused += 1;
                    gamepaused %= 2;
                }
            }
        }

        if(ev.type == ALLEGRO_EVENT_KEY_DOWN)
        {
            switch(ev.keyboard.keycode)
            {
            case ALLEGRO_KEY_W:
                key[KEY_W] = true;
                break;

            case ALLEGRO_KEY_S:
                key[KEY_S] = true;
                break;

            case ALLEGRO_KEY_A:
                key[KEY_A] = true;
                break;

            case ALLEGRO_KEY_D:
                key[KEY_D] = true;
                break;

            case ALLEGRO_KEY_R:
                slow_speed += 1;
                slow_speed %= 2;
                key[KEY_R] = true;
                break;

            case ALLEGRO_KEY_F:
                wire_mode += 1;
                wire_mode %= 2;
                key[KEY_F] = true;
                break;

            case ALLEGRO_KEY_P:
                eye[0]=0.0;
                eye[1]=0.0;
                eye[2]=9.0;
                phi=100.0;
                theta=0.0;
                key[KEY_P] = true;
                break;

            case ALLEGRO_KEY_LCTRL:
                key[KEY_LCTRL] = true;
                break;

            case ALLEGRO_KEY_SPACE:
                key[KEY_SPACE] = true;
                break;

            case ALLEGRO_KEY_ESCAPE:
                gamepaused += 1;
                gamepaused %= 2;       // toggle game paused state
                break;

            case ALLEGRO_KEY_ALT:
                key[KEY_ALT] = true;
                break;

            case ALLEGRO_KEY_F4:
                if (key[KEY_ALT] == true)          // alt-F4 exits
                {
                    doexit = true;
                }
                break;
            }
        }
        else if(ev.type == ALLEGRO_EVENT_KEY_UP)
        {
            switch(ev.keyboard.keycode)
            {
            case ALLEGRO_KEY_W:
                key[KEY_W] = false;
                break;

            case ALLEGRO_KEY_S:
                key[KEY_S] = false;
                break;

            case ALLEGRO_KEY_A:
                key[KEY_A] = false;
                break;

            case ALLEGRO_KEY_D:
                key[KEY_D] = false;
                break;

            case ALLEGRO_KEY_R:
                key[KEY_R] = false;
                break;

            case ALLEGRO_KEY_F:
                key[KEY_F] = false;
                break;

            case ALLEGRO_KEY_P:
                key[KEY_P] = false;
                break;

            case ALLEGRO_KEY_LCTRL:
                key[KEY_LCTRL] = false;
                break;

            case ALLEGRO_KEY_SPACE:
                key[KEY_SPACE] = false;
                break;

            case ALLEGRO_KEY_ALT:
                key[KEY_ALT] = false;
                break;
            }
        }

        if(redraw && al_is_event_queue_empty(event_queue))
        {
            al_clear_to_color(al_map_rgb(0,0,0));

            mers_init_genrand(0);
            for (int i = 0; i <= NUMBEROFSTARS-1; i += 1)
            {
                int ticks = 30*24*60;
                double s_azimuth = M_2PIE*(mers_genrand_real1()+(timercount%ticks)/(ticks*1.0))+0.31416;
                double s_elevation = acosf(mers_genrand_real1()*2.0-1.0)-ALLEGRO_PI/2.0;
                double s_range = pow(1.06,mers_genrand_real1()*100.0)-1.06+0.0;
                if (s_range < 1.06) s_range = sqrt( mers_genrand_real1()*1.1236 );
                stars [i][0] = (sinf(s_azimuth)*cosf(s_elevation)*s_range)+0.0;//*32000;//i;
                stars [i][2] = (cosf(s_azimuth)*cosf(s_elevation)*s_range)+0.0;//*32000;//i;
                stars [i][1] = (sinf(s_elevation)*s_range)/2.0+0.0;//*16000;//i;
                stars_brightness [i][0] = mers_genrand_real1();
            }

            e3d[4]=fast_floor(eye[0])-e3d[2];
            e3d[5]=fast_floor(eye[1])-e3d[3];
            e3d[0]=s3d+fast_floor(eye[0]/(s3d*1.0))*s3d-fast_floor(eye[0])-1;
            e3d[1]=s3d+fast_floor(eye[1]/(s3d*1.0))*s3d-fast_floor(eye[1])-1;
            e3d[2]=fast_floor(eye[0]);
            e3d[3]=fast_floor(eye[1]);

            {
                for (int h2 = 0; h2<=1; h2++)
                {
                    int i2 = e3d[0];
                    for (int i = 0; i <= s3d; i+=1)
                    {
                        int j2 = e3d[1];
                        for (int j = 0; j <= s3d; j+=1)
                        {
                            int n = 1;
                            int h = h2%2;
                            if((!(i2>=(-e3d[4]+n) && i2<=(s3d-e3d[4]-n) && j2>=(-e3d[5]+n) && j2<=(s3d-e3d[5]-n)))||h||(timercount<10))
                            {
                                int x = (i2)+fast_floor(eye[0]/1.0)*1;
                                int y = (j2)+fast_floor(eye[1]/1.0)*1;
                                t3d[h][i][j][0] = (i2)-(w3d/2)+fast_floor(eye[0]);//-e3d[0];
                                t3d[h][i][j][1] = (j2)-(w3d/2)+fast_floor(eye[1]);//-e3d[1];
                                float noise_result = 0.0;
                                float d_t[8] = { 1.0, 1.0, 0, 0, 1.0, 0, 0, 1.0 };
                                float rgb[6] = { 0, 0, 0, 0, 0, 0 };
                                rgb[0] = noise2d( (x-0.33)/12.0,(y-0.33)/12.0,1);
                                rgb[1] = noise2d( (x-0.33)/18.0,(y-0.33)/18.0,2);
                                rgb[2] = noise2d( (x-0.33)/12.0,(y-0.33)/12.0,3);
                                rgb[3] = noise2d( (x+0.33)/12.0,(y+0.33)/12.0,1);
                                rgb[4] = noise2d( (x+0.33)/18.0,(y+0.33)/18.0,2);
                                rgb[5] = noise2d( (x+0.33)/12.0,(y+0.33)/12.0,3);
                                if(h)
                                {
                                    noise_result = ( noise3d(x/4.0,y/4.0,timercount/100.0,0) + noise3d(x/4.0,y/4.0,timercount/100.0+0.5,0) )*0.2+0.5;
                                    d_t[0] = noise3d( (x-0.33)/2.0,(y-0.33)/2.0,timercount/42.0,4 )*0.25+0.5;
                                    d_t[1] = noise3d( (x+0.33)/2.0,(y+0.33)/2.0,timercount/42.0,4 )*0.25+0.5;
                                    t3d[h][i][j][3] = d_t[0]*ambient_l*(rgb[0]*c3d[0+6*h]+c3d[1+6*h]);
                                    t3d[h][i][j][4] = d_t[0]*ambient_l*(rgb[1]*c3d[2+6*h]+c3d[3+6*h]);
                                    t3d[h][i][j][5] = d_t[0]*ambient_l*(rgb[2]*c3d[4+6*h]+c3d[5+6*h]);
                                    t3d[h][i][j][6] = d_t[1]*ambient_l*(rgb[3]*c3d[0+6*h]+c3d[1+6*h]);
                                    t3d[h][i][j][7] = d_t[1]*ambient_l*(rgb[4]*c3d[2+6*h]+c3d[3+6*h]);
                                    t3d[h][i][j][8] = d_t[1]*ambient_l*(rgb[5]*c3d[4+6*h]+c3d[5+6*h]);
                                }
                                else
                                {
                                    float noise_scale = 64;
                                    float noise_oct = 0.5;
                                    for (int k = 0; k <= 5; k++)
                                    {
                                        noise_result += noise2d( (x+0.17)/noise_scale,(y+0.17)/noise_scale,0 ) / noise_oct;
                                        noise_scale /= 2.0;
                                        noise_oct *= 1.41421;
                                    }
                                    noise_result *= noise_result;
                                    noise_scale = 144;
                                    //noise_result *= -( noise2d( (x+0.33)/noise_scale,(y+0.33)/noise_scale,0 )+0.67 );
                                    noise_scale = 240;
                                    //noise_result *= -( noise2d( (x+0.33)/noise_scale,(y+0.33)/noise_scale,0 )+0.933 );
                                    noise_result *= 2.0;
                                    float s_ = 32.0;
                                    float e_ = 2.71828;
                                    float pi_ = 3.141596;
                                    int x2 = x - s3d/2;
                                    int y2 = y - s3d/2;
                                    float d_ = 0.0-(x2*x2+y2*y2)/(2.0*s_*s_);
                                    noise_result += pow(e_,d_) / (sqrt(2*pi_)*s_)*s_*16.4-2.0;
                                    d_t[0] = noise2d( (x-0.33)/3.0,(y-0.33)/3.0,4 )*0.333;
                                    d_t[1] = noise2d( (x+0.33)/3.0,(y+0.33)/3.0,4 )*0.333;
                                    d_t[0] += noise2d( (x-0.33)/5.0,(y-0.33)/5.0,4 )*0.667;
                                    d_t[1] += noise2d( (x+0.33)/5.0,(y+0.33)/5.0,4 )*0.667;
                                    d_t[0] = d_t[0]*0.5+0.5;
                                    d_t[1] = d_t[1]*0.5+0.5;
                                    d_t[2] = noise2d( (x-0.33)/3.0,(y-0.33)/3.0,5 )/2.0;
                                    d_t[3] = noise2d( (x-0.33)/3.0,(y-0.33)/3.0,6 )/2.0;
                                    d_t[4] = noise2d( d_t[2]+(x-0.33)/4.0, d_t[3]+(y-0.33)/4.0, 7)*0.2+0.8;
                                    d_t[5] = noise2d( (x+0.33)/3.0,(y+0.33)/3.0,5 )/2.0;
                                    d_t[6] = noise2d( (x+0.33)/3.0,(y+0.33)/3.0,6 )/2.0;
                                    d_t[7] = noise2d( d_t[2]+(x+0.33)/4.0, d_t[3]+(y+0.33)/4.0, 7)*0.2+0.8;
                                    t3d[h][i][j][3] = d_t[4]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[0]*(noise2d( (x-0.33)/12.0,(y-0.33)/12.0,1 )*c3d[0+6*h]+c3d[1+6*h]) ) );
                                    t3d[h][i][j][4] = d_t[4]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[0]*(noise2d( (x-0.33)/18.0,(y-0.33)/18.0,2 )*c3d[2+6*h]+c3d[3+6*h]) ) );
                                    t3d[h][i][j][5] = d_t[4]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[0]*(noise2d( (x-0.33)/12.0,(y-0.33)/12.0,3 )*c3d[4+6*h]+c3d[5+6*h]) ) );
                                    t3d[h][i][j][6] = d_t[7]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[1]*(noise2d( (x+0.33)/12.0,(y+0.33)/12.0,1)*c3d[0+6*h]+c3d[1+6*h]) ) );
                                    t3d[h][i][j][7] = d_t[7]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[1]*(noise2d( (x+0.33)/18.0,(y+0.33)/18.0,2)*c3d[2+6*h]+c3d[3+6*h]) ) );
                                    t3d[h][i][j][8] = d_t[7]*ambient_l*( 1.0-(7.0-noise_result)/7.0*( 1.0-d_t[1]*(noise2d( (x+0.33)/12.0,(y+0.33)/12.0,3)*c3d[4+6*h]+c3d[5+6*h]) ) );
                                }

                                t3d[h][i][j][2] = noise_result;//noise2d(x/4.0,y/4.0,0)*1.0;
                            }
                            j2 += 1;
                            j2 -= s3d*(j2>=s3d);
                        }
                        i2 += 1;
                        i2 -= s3d*(i2>=s3d);
                    }
                }
            }

            glEnable(GL_DEPTH_TEST);
            glDepthMask(GL_TRUE);
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
            glMatrixMode(GL_PROJECTION);
            glLoadIdentity();
            gluPerspective(85,aspect_ratio,0.001,1000000);
            gluLookAt(eye[0],eye[1],eye[2],                            // camera is here
                      looking_at[0],looking_at[1],looking_at[2],       // camera is looking towards this point
                      0.0f,0.0f,1.0f);                                 // up vector

            glMatrixMode(GL_MODELVIEW);
            glLoadIdentity();
            if(wire_mode)
            {
                glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
            }
            else
            {
                glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            }

            if(1)
            {
                glBegin(GL_POINTS);
                for(int i = 0; i <= NUMBEROFSTARS-1; i+=1)
                {
                    float x = stars[i][0];// - eye[0];
                    float y = stars[i][1];// - eye[1];
                    float z = stars[i][2];// - eye[2];
                    double brightness = 100.0*stars_brightness[i][0]/( 1.0*(x*x+y*y+z*z) );
                    if (brightness>1.0)
                    {
                        brightness = 1.0;
                    }
                    glColor3d(brightness,brightness,brightness);
                    glVertex3d(stars[i][0]+eye[0],stars[i][1]+eye[1],stars[i][2]+eye[2]);
                }
                glEnd();
            }
            glClear(GL_DEPTH_BUFFER_BIT);

            glBegin(GL_TRIANGLE_FAN);
            glColor3d(0.02,0.02,0.02);
            glVertex3d( 0.0, 0.0, 0.5);
            glVertex3d( -900900.9, -373164.8, 0.5);
            glVertex3d( -373164.8, -900900.9, 0.5);
            glVertex3d( 373164.8, -900900.9, 0.5);
            glVertex3d( 900900.9, -373164.8, 0.5);
            glVertex3d( 900900.9, 373164.8, 0.5);
            glVertex3d( 373164.8, 900900.9, 0.5);
            glVertex3d( -373164.8, 900900.9, 0.5);
            glVertex3d( -900900.9, 373164.8, 0.5);
            glVertex3d( -900900.9, -373164.8, 0.5);
            glEnd();
            glClear(GL_DEPTH_BUFFER_BIT);

            // 3d drawing code
            {
                for (int h2 = 0; h2<=1; h2++)
                {
                    int i2 = e3d[0];
                    for (int i = 0; i <= s3d-1; i+=1)
                    {
                        int j2 = e3d[1];
                        for (int j = 0; j <= s3d-1; j+=1)
                        {
                            int h = h2%2;
                            if (i2<s3d-1&&j2<s3d-1)
                            {
                                float r1 = t3d[h][i][j][3];
                                float g1 = t3d[h][i][j][4];
                                float b1 = t3d[h][i][j][5];
                                float r2 = t3d[h][i][j][6];
                                float g2 = t3d[h][i][j][7];
                                float b2 = t3d[h][i][j][8];
                                float x[4] = { 0, 0, 0, 0 };
                                float y[4] = { 0, 0, 0, 0 };
                                float z[4] = { 0, 0, 0, 0 };
                                float cs[24] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
                                for (int k = 0; k < 4; k+=1)
                                {
                                    x[k]=(i2+k/2)-(w3d/2)+fast_floor(eye[0]);//*w3d-w3d/2.0;
                                    y[k]=(j2+k%2)-(w3d/2)+fast_floor(eye[1]);//*w3d-w3d/2.0;

                                    if (1)
                                    {
                                        for (int l = 0; l < 3; l++)
                                        {
                                            cs[12+k*3+l] = t3d[h][i+k/2][j+k%2][0+l];
                                            cs[k*3+l] = t3d[h][i+k/2][j+k%2][3+l];
                                        }
                                    }
                                    if(0)

                                    {

                                        cs[0]=1.0;
                                        cs[1]=0.0;
                                        cs[2]=0.0;
                                        cs[3]=0.0;
                                        cs[4]=1.0;
                                        cs[5]=0.0;
                                        cs[6]=0.0;
                                        cs[7]=0.0;
                                        cs[8]=1.0;
                                        cs[9]=0.5;
                                        cs[10]=0.5;
                                        cs[11]=0.5;
                                    }
                                    x[k]=t3d[h][i+k/2][j+k%2][0];
                                    y[k]=t3d[h][i+k/2][j+k%2][1];
                                    z[k]=t3d[h][i+k/2][j+k%2][2];
                                }
                                r1 = (cs[0]+cs[3]+cs[6])/3.0;
                                g1 = (cs[1]+cs[4]+cs[7])/3.0;
                                b1 = (cs[2]+cs[5]+cs[8])/3.0;
                                r2 = (cs[9]+cs[3]+cs[6])/3.0;
                                g2 = (cs[10]+cs[4]+cs[7])/3.0;
                                b2 = (cs[11]+cs[5]+cs[8])/3.0;
                                float s_c[3]; // square centre
                                s_c[0] = (x[1]+x[2])/2.0;
                                s_c[1] = (y[1]+y[2])/2.0;
                                s_c[2] = (z[1]+z[2])/2.0;
                                float distances = pow( pow((s_c[0]-eye[0]),2.0)+pow((s_c[1]-eye[1]),2.0)+pow((s_c[2]-eye[2]),2.0), 1.0 ); // distance fog underwater - fog to grey
                                if (distances<0.001) distances = 0.001;
                                float s_t_e = (0.28*w3d*w3d)/( distances )-1.0; // square to eye
                                float t = s_t_e;
                                s_t_e = 0.9*( t * t * t * ( t * ( t * 6 - 15 ) + 10 ) );
                                if (s_t_e>1.0) s_t_e=1.0;
                                if (s_t_e<0.0) s_t_e=0.0;
                                float distance1 = sqrt(distances);
                                if (distance1<(w3d/4.0))
                                {
                                    int which_level = 0+int(floor ( log2(w3d/distance1) / log2(2.0) ) );
                                    float log_interpolant = log2(w3d/distance1) / log2(2.0)-floor ( log2(w3d/distance1) / log2(2.0) );
                                    float one_minus_log_i = 1.0 - log_interpolant;
                                    if (which_level > 5) which_level = 5;

                                    if (0)
                                    {


                                        if (distance1<(w3d/8.0))
                                        {
                                            which_level = 3;
                                        }
                                        if (distance1<(w3d/16.0))
                                        {
                                            which_level = 4;
                                        }
                                        if (distance1<(w3d/32.0))
                                        {
                                            which_level = 5;
                                        }
                                        if (distance1<(w3d/32.0))
                                        {
                                            which_level = 5;
                                        }
                                        if (distance1<(w3d/32.0))
                                        {
                                            which_level = 5;
                                        }

                                    }


                                    int level_width = 1;
                                    for (int k = 1; k < which_level; k++)
                                    {
                                        level_width *= 2;
                                    }
                                    float level_ele = level_width;
                                    float fine_detail_scale = pow (level_ele/0.4, 1.5);
                                    float ele2 = level_ele * -4.0;
                                    level_width += 1;
                                    int n_vertices = level_width*level_width;
                                    float co[n_vertices*6];
                                    float cs2[n_vertices*6];
                                    for (int k = 0; k < level_width; k++)
                                    {
                                        for (int l = 0; l < level_width; l++)
                                        {
                                            float k2 = ( k/(level_width-1.0) );
                                            float l2 = ( l/(level_width-1.0) );
                                            float k3 = 1.0-k2;
                                            float l3 = 1.0-l2;
                                            int cvar1 = 0;
                                            int cvar2 = 3;
                                            int cvar3 = 6;
                                            //int cvar4 = 9;
                                            //int cvar5 = 0;
                                            int cvar6 = 3;
                                            int cvar7 = 6;
                                            int cvar8 = 9;
                                            if (k+l<level_width-1)
                                            {
                                                co[0+6*(level_width*k+l)] = x[0]+1.0*k2*(x[2]-x[0])+1.0*l2*(x[1]-x[0]);
                                                co[1+6*(level_width*k+l)] = y[0]+1.0*k2*(y[2]-y[0])+1.0*l2*(y[1]-y[0]);
                                                co[2+6*(level_width*k+l)] = z[0]+1.0*k2*(z[2]-z[0])+1.0*l2*(z[1]-z[0]);
                                                cs2[0+3*(level_width*k+l)] = cs[cvar1+0]+1.0*k2*(cs[cvar3+0]-cs[cvar1+0])+1.0*l2*(cs[cvar2+0]-cs[cvar1+0]);
                                                cs2[1+3*(level_width*k+l)] = cs[cvar1+1]+1.0*k2*(cs[cvar3+1]-cs[cvar1+1])+1.0*l2*(cs[cvar2+1]-cs[cvar1+1]);
                                                cs2[2+3*(level_width*k+l)] = cs[cvar1+2]+1.0*k2*(cs[cvar3+2]-cs[cvar1+2])+1.0*l2*(cs[cvar2+2]-cs[cvar1+2]);
                                            }
                                            else
                                            {
                                                co[0+6*(level_width*k+l)] = x[3]+1.0*k3*(x[1]-x[3])+1.0*l3*(x[2]-x[3]);
                                                co[1+6*(level_width*k+l)] = y[3]+1.0*k3*(y[1]-y[3])+1.0*l3*(y[2]-y[3]);
                                                co[2+6*(level_width*k+l)] = z[3]+1.0*k3*(z[1]-z[3])+1.0*l3*(z[2]-z[3]);
                                                cs2[0+3*(level_width*k+l)] = cs[cvar8+0]+1.0*k3*(cs[cvar6+0]-cs[cvar8+0])+1.0*l3*(cs[cvar7+0]-cs[cvar8+0]);
                                                cs2[1+3*(level_width*k+l)] = cs[cvar8+1]+1.0*k3*(cs[cvar6+1]-cs[cvar8+1])+1.0*l3*(cs[cvar7+1]-cs[cvar8+1]);
                                                cs2[2+3*(level_width*k+l)] = cs[cvar8+2]+1.0*k3*(cs[cvar6+2]-cs[cvar8+2])+1.0*l3*(cs[cvar7+2]-cs[cvar8+2]);
                                            }

                                            if(h)
                                            {
                                                co[3+6*(level_width*k+l)] = s_t_e * (noise3d( (co[0+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,(co[1+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,timercount/21.0+20.0,14 )*0.1+1.0);
                                                co[4+6*(level_width*k+l)] = s_t_e * (noise3d( (co[0+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,(co[1+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,timercount/21.0+20.0,15 )*0.2+1.0);
                                                co[5+6*(level_width*k+l)] = s_t_e * (noise3d( (co[0+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,(co[1+6*(level_width*(k-0)+l-0)]+0.333/ele2)*8.0,timercount/21.0+20.0,16 )*0.1+1.0);
                                            }
                                            else
                                            {
                                                co[3+6*(level_width*k+l)] = s_t_e * ( ( noise2d( (co[0+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,7 ) +
                                                                                        noise2d( (co[0+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,12 )*fine_detail_scale )*0.04 + 1.0
                                                                                    );
                                                co[4+6*(level_width*k+l)] = s_t_e * ( ( noise2d( (co[0+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,8 ) +
                                                                                        noise2d( (co[0+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,12 )*fine_detail_scale )*0.04 + 1.0
                                                                                    );
                                                co[5+6*(level_width*k+l)] = s_t_e * ( ( noise2d( (co[0+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*4.0-0.333/ele2,9 ) +
                                                                                        noise2d( (co[0+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,(co[1+6*(level_width*k+l)]+0.0)*16.0-0.333/ele2,12 )*fine_detail_scale )*0.02 + 1.0
                                                                                    );
                                            }


                                        }
                                    }
                                    for (int k = 1; k < level_width-0; k++)
                                    {
                                        for (int l = 1; l < level_width-0; l++)
                                        {
                                            float new_r;
                                            float new_g;
                                            float new_b;
                                            r1 = ( cs2[0+3*(level_width*(k-0)+l-0)]+cs2[0+3*(level_width*(k-0)+l-1)]+cs2[0+3*(level_width*(k-1)+l-0)] )/3.0;
                                            g1 = ( cs2[1+3*(level_width*(k-0)+l-0)]+cs2[1+3*(level_width*(k-0)+l-1)]+cs2[1+3*(level_width*(k-1)+l-0)] )/3.0;
                                            b1 = ( cs2[2+3*(level_width*(k-0)+l-0)]+cs2[2+3*(level_width*(k-0)+l-1)]+cs2[2+3*(level_width*(k-1)+l-0)] )/3.0;
                                            r2 = ( cs2[0+3*(level_width*(k-1)+l-1)]+cs2[0+3*(level_width*(k-0)+l-1)]+cs2[0+3*(level_width*(k-1)+l-0)] )/3.0;
                                            g2 = ( cs2[1+3*(level_width*(k-1)+l-1)]+cs2[1+3*(level_width*(k-0)+l-1)]+cs2[1+3*(level_width*(k-1)+l-0)] )/3.0;
                                            b2 = ( cs2[2+3*(level_width*(k-1)+l-1)]+cs2[2+3*(level_width*(k-0)+l-1)]+cs2[2+3*(level_width*(k-1)+l-0)] )/3.0;
                                            if (1)
                                            {
                                                new_r = ( co[3+6*(level_width*(k-0)+l-0)]+co[3+6*(level_width*(k-0)+l-1)]+co[3+6*(level_width*(k-1)+l-0)] )/3.0;
                                                new_g = ( co[4+6*(level_width*(k-0)+l-0)]+co[4+6*(level_width*(k-0)+l-1)]+co[4+6*(level_width*(k-1)+l-0)] )/3.0;
                                                new_b = ( co[5+6*(level_width*(k-0)+l-0)]+co[5+6*(level_width*(k-0)+l-1)]+co[5+6*(level_width*(k-1)+l-0)] )/3.0;
//    if (texture != 0)
//        glBindTexture(GL_TEXTURE_2D, texture);

                                                glBegin(GL_TRIANGLES);
                                                glColor3d(0.02+r1*new_r,
                                                          0.02+g1*new_g,
                                                          0.02+b1*new_b);
//                                                          glTexCoord2d(1, 1);
                                                glVertex3d( co[0+6*(level_width*(k-0)+l-0)],co[1+6*(level_width*(k-0)+l-0)],co[2+6*(level_width*(k-0)+l-0)] );
//                                                          glTexCoord2d(1, 0);
                                                glVertex3d( co[0+6*(level_width*(k-0)+l-1)],co[1+6*(level_width*(k-0)+l-1)],co[2+6*(level_width*(k-0)+l-1)] );
//                                                          glTexCoord2d(0, 1);
                                                glVertex3d( co[0+6*(level_width*(k-1)+l-0)],co[1+6*(level_width*(k-1)+l-0)],co[2+6*(level_width*(k-1)+l-0)] );
                                                glEnd();

                                            }
                                            if (1)
                                            {
                                                new_r = ( co[3+6*(level_width*(k-1)+l-1)]+co[3+6*(level_width*(k-0)+l-1)]+co[3+6*(level_width*(k-1)+l-0)] )/3.0;
                                                new_g = ( co[4+6*(level_width*(k-1)+l-1)]+co[4+6*(level_width*(k-0)+l-1)]+co[4+6*(level_width*(k-1)+l-0)] )/3.0;
                                                new_b = ( co[5+6*(level_width*(k-1)+l-1)]+co[5+6*(level_width*(k-0)+l-1)]+co[5+6*(level_width*(k-1)+l-0)] )/3.0;
//                                                    if (texture != 0)
//        glBindTexture(GL_TEXTURE_2D, texture);

                                                glBegin(GL_TRIANGLES);
                                                glColor3d(0.02+r2*new_r,
                                                          0.02+g2*new_g,
                                                          0.02+b2*new_b);
                                                if(0)
                                                {
                                                    glColor3d(0.25,0.25,0.25);
                                                }
//                                                          glTexCoord2d(1, 0);
                                                glVertex3d( co[0+6*(level_width*(k-0)+l-1)],co[1+6*(level_width*(k-0)+l-1)],co[2+6*(level_width*(k-0)+l-1)] );
//                                                          glTexCoord2d(0, 1);
                                                glVertex3d( co[0+6*(level_width*(k-1)+l-0)],co[1+6*(level_width*(k-1)+l-0)],co[2+6*(level_width*(k-1)+l-0)] );
//                                                          glTexCoord2d(0, 0);
                                                glVertex3d( co[0+6*(level_width*(k-1)+l-1)],co[1+6*(level_width*(k-1)+l-1)],co[2+6*(level_width*(k-1)+l-1)] );
                                                glEnd();
                                            }

                                        }
                                    }

                                }
                                else
                                {
                                    glBegin(GL_TRIANGLE_STRIP);
                                    glColor3d(0.02+r1*s_t_e,0.02+g1*s_t_e,0.02+b1*s_t_e);
                                    glVertex3d(x[0],y[0],z[0]);
                                    glVertex3d(x[1],y[1],z[1]);
                                    glVertex3d(x[2],y[2],z[2]);
                                    glEnd();
                                    glBegin(GL_TRIANGLE_STRIP);
                                    glColor3d(0.02+r2*s_t_e,0.02+g2*s_t_e,0.02+b2*s_t_e);
                                    glVertex3d(x[1],y[1],z[1]);
                                    glVertex3d(x[2],y[2],z[2]);
                                    glVertex3d(x[3],y[3],z[3]);
                                    glEnd();
                                }
                            }
                            j2 += 1;
                            j2 -= s3d*(j2>=s3d);
                        }
                        i2 += 1;
                        i2 -= s3d*(i2>=s3d);
                    }
                }
            }

            glMatrixMode (GL_PROJECTION);
            glLoadIdentity ();
            glOrtho (0, d_w, d_h, 0, 0, 1);
            glDisable(GL_DEPTH_TEST);
            glMatrixMode (GL_MODELVIEW);
            glLoadIdentity();

            // 2d drawing code
            if (!gamepaused)
            {
                float aim_spread2 = 16.0*(1.0 + aim_spread)*d_h/1440.0;
                float aim_spread3 = 22.0*(1.0 + aim_spread)*d_h/1440.0;
                glBegin(GL_LINES);
                glColor3f(0.8,0.8,1.0);
                glVertex2d(d_w/2-aim_spread3,d_h/2);
                glVertex2d(d_w/2-aim_spread2,d_h/2);
                glVertex2d(d_w/2,d_h/2-aim_spread3);
                glVertex2d(d_w/2,d_h/2-aim_spread2);
                glVertex2d(d_w/2+aim_spread3,d_h/2);
                glVertex2d(d_w/2+aim_spread2,d_h/2);
                glVertex2d(d_w/2,d_h/2+aim_spread3);
                glVertex2d(d_w/2,d_h/2+aim_spread2);
                glEnd();
            }

            if(0)
            {

                glBegin(GL_POINTS);
                for (int i = 0; i < 2560; i++)
                {

                    for (int j = 0; j < 1440; j++)
                    {
                        float noise_bw = pnoise2d ( i / 8.0, j / 8.0, 32, 32, 0)*2.0/7.0+pnoise2d ( i / 4.0, j / 4.0, 64, 64, 1)*1.0/7.0+pnoise2d ( i / 2.0, j / 2.0, 128, 128, 2)*0.5/7.0+0.5;
                        glColor3f(noise_bw,noise_bw,noise_bw);
                        glVertex2d(0+i-128*0,0+j-128*0);
                    }
                }
                glEnd();
            }


            if(1)
            {
                glDisable(GL_DEPTH_TEST);
                glDepthMask(GL_FALSE);

                glMatrixMode(GL_PROJECTION);
                glLoadIdentity();
                gluPerspective(85,aspect_ratio,0.001,6800);

                gluLookAt(d_w/2.0,d_h/2.0,0.0-d_h*59.0/108.0, // camera is here
                          d_w/2.0,d_h/2.0,1.0-d_h*59.0/108.0, // camera is looking towards this point
                          0.0f,-1.0f,0.0f);                   // up vector

                glMatrixMode(GL_MODELVIEW);
                glLoadIdentity();
                if(wire_mode)
                {
                    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                }
                else
                {
                    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                }
                glClear(GL_DEPTH_BUFFER_BIT);
                glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            }

            // Allegro OpenGL code for drawing and text

            if (gamepaused)                                                                                      // menu drawing
            {
                al_draw_filled_rectangle( d_w*0.35, d_h*0.61, d_w*0.65, d_h*0.69, al_map_rgb(127, 127, 127) );
                al_draw_rectangle( d_w*0.35, d_h*0.61, d_w*0.65, d_h*0.69, al_map_rgb(63, 63, 63),2 );
                al_draw_textf( font_tt, al_map_rgb(15,15,15), d_w/2, d_h*0.65-12.0*d_h/1080.0, ALLEGRO_ALIGN_CENTRE, "Quit" );
                al_draw_filled_rectangle( d_w*0.35, d_h*0.41, d_w*0.65, d_h*0.49, al_map_rgb(127, 127, 127) );
                al_draw_rectangle( d_w*0.35, d_h*0.41, d_w*0.65, d_h*0.49, al_map_rgb(63, 63, 63),2 );
                al_draw_textf( font_tt, al_map_rgb(15,15,15), d_w/2, d_h*0.45-12.0*d_h/1080.0, ALLEGRO_ALIGN_CENTRE, "Resume" );
                al_draw_filled_rectangle( d_w*0.35, d_h*0.51, d_w*0.65, d_h*0.59, al_map_rgb(127, 127, 127) );
                al_draw_rectangle( d_w*0.35, d_h*0.51, d_w*0.65, d_h*0.59, al_map_rgb(63, 63, 63),2 );

                if (y_axis==1)                                                                       // 'y axis is inverted' checkbox
                {
                    al_draw_line( d_w*(0.65-.07*d_h/d_w), d_h*0.52, d_w*(0.65-.01*d_h/d_w), d_h*0.58,
                                  al_map_rgb(15, 15, 15),2);
                    al_draw_line( d_w*(0.65-.07*d_h/d_w), d_h*0.58, d_w*(0.65-.01*d_h/d_w), d_h*0.52,
                                  al_map_rgb(15, 15, 15),2);
                }
                al_draw_rectangle( d_w*(0.65-.07*d_h/d_w), d_h*0.52, d_w*(0.65-.01*d_h/d_w), d_h*0.58,
                                   al_map_rgb(15, 15, 15),2);
                al_draw_textf(font_tt, al_map_rgb(15,15,15), d_w/2, d_h*0.55-12.0*d_h/1080.0, ALLEGRO_ALIGN_CENTRE, "y Inverted");

                al_draw_line( cursor_x-20.0, cursor_y,                                                                      // cursor
                              cursor_x+20.0, cursor_y,
                              al_map_rgb(191, 191, 191),2 );
                al_draw_line( cursor_x, cursor_y-20.0,
                              cursor_x, cursor_y+20.0,
                              al_map_rgb(63, 63, 63),2 );
                al_draw_textf( font_tt, al_map_rgb(255,255,255), d_w/2, 24.0*d_h/1080.0,
                               ALLEGRO_ALIGN_CENTRE, "x %f y %f", cursor_x, cursor_y);                              // mouse position
            }
            else
            {
                al_set_mouse_xy(display,d_w/2,d_h/2);                                                           // set mouse position
                al_draw_textf( font_tt, al_map_rgb(255,255,255),                                                    // camera position
                               d_w/2, 48.0*d_h/1080.0, ALLEGRO_ALIGN_CENTRE, "x %f y %f z %f phi %f theta %f aim %f",
                               eye[0],eye[1],eye[2],phi,theta,aim_spread );         // position, phi, theta
            }
            redraw = false;
            al_flip_display();
        }
    }
    al_destroy_timer(timer);
    al_destroy_display(display);
    al_destroy_event_queue(event_queue);
    return 0;
}
