//beginning of mersenne twister code

/*
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Before using, initialize the state by using init_genrand(seed)
   or init_by_array(init_key, key_length).

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


   Any feedback is very welcome.
   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
   ***** end of mersenne twister disclaimer
*/

/* Period parameters */
#define mersNnn 624
#define mersMnn 397
#define mersMATRIX_A 0x9908b0dfUL   /* constant vector a */
#define mersUPPER_MASK 0x80000000UL /* most significant w-r bits */
#define mersLOWER_MASK 0x7fffffffUL /* least significant r bits */
#include <cmath>
static unsigned long mers_mt_nn[mersNnn]; /* the array for the state vector  */
static int mers_mti_nn=mersNnn+1; /* mers_mti_nn==mersNnn+1 means mers_mt_nn[mersNnn] is not initialized */

/* initializes mers_mt_nn[mersNnn] with a seed */
void mers_init_genrand(unsigned long mers_s_nn)
{
    mers_mt_nn[0]= mers_s_nn & 0xffffffffUL;
    for (mers_mti_nn=1; mers_mti_nn<mersNnn; mers_mti_nn++)
    {
        mers_mt_nn[mers_mti_nn] =
            (1812433253UL * (mers_mt_nn[mers_mti_nn-1] ^ (mers_mt_nn[mers_mti_nn-1] >> 30)) + mers_mti_nn);
        /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
        /* In the previous versions, MSBs of the seed affect   */
        /* only MSBs of the array mers_mt_nn[].                */
        /* 2002/01/09 modified by Makoto Matsumoto             */
        mers_mt_nn[mers_mti_nn] &= 0xffffffffUL;
        /* for >32 bit machines */
    }
}

/* initialize by an array with array-length */
/* mers_init_key is the array for initializing keys */
/* mers_key_length is its length */
/* slight change for C++, 2004/2/26 */
void mers_init_by_array(unsigned long mers_init_key[], int mers_key_length)
{
    int mers_i_nn, mers_j_nn, mers_k_nn;
    mers_init_genrand(19650218UL);
    mers_i_nn=1;
    mers_j_nn=0;
    mers_k_nn = (mersNnn>mers_key_length ? mersNnn : mers_key_length);
    for (; mers_k_nn; mers_k_nn--)
    {
        mers_mt_nn[mers_i_nn] = (mers_mt_nn[mers_i_nn] ^ ((mers_mt_nn[mers_i_nn-1] ^ (mers_mt_nn[mers_i_nn-1] >> 30)) * 1664525UL))
                                + mers_init_key[mers_j_nn] + mers_j_nn; /* non linear */
        mers_mt_nn[mers_i_nn] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
        mers_i_nn++;
        mers_j_nn++;
        if (mers_i_nn>=mersNnn)
        {
            mers_mt_nn[0] = mers_mt_nn[mersNnn-1];
            mers_i_nn=1;
        }
        if (mers_j_nn>=mers_key_length) mers_j_nn=0;
    }
    for (mers_k_nn=mersNnn-1; mers_k_nn; mers_k_nn--)
    {
        mers_mt_nn[mers_i_nn] = (mers_mt_nn[mers_i_nn] ^ ((mers_mt_nn[mers_i_nn-1] ^ (mers_mt_nn[mers_i_nn-1] >> 30)) * 1566083941UL))
                                - mers_i_nn; /* non linear */
        mers_mt_nn[mers_i_nn] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
        mers_i_nn++;
        if (mers_i_nn>=mersNnn)
        {
            mers_mt_nn[0] = mers_mt_nn[mersNnn-1];
            mers_i_nn=1;
        }
    }

    mers_mt_nn[0] = 0x80000000UL; /* MSB is 1; assuring non-zero initial array */
}

/* generates a random number on [0,0xffffffff]-interval */
unsigned long mers_genrand_int32(void)
{
    unsigned long mers_y_nn;
    static unsigned long mers_mag01[2]= {0x0UL, mersMATRIX_A};
    /* mers_mag01[x] = x * mersMATRIX_A  for x=0,1 */

    if (mers_mti_nn >= mersNnn)   /* generate mersNnn words at one time */
    {
        int mers_kk_nn;

        if (mers_mti_nn == mersNnn+1)   /* if mers_init_genrand() has not been called, */
            mers_init_genrand(5489UL); /* a default initial seed is used */

        for (mers_kk_nn=0; mers_kk_nn<mersNnn-mersMnn; mers_kk_nn++)
        {
            mers_y_nn = (mers_mt_nn[mers_kk_nn]&mersUPPER_MASK)|(mers_mt_nn[mers_kk_nn+1]&mersLOWER_MASK);
            mers_mt_nn[mers_kk_nn] = mers_mt_nn[mers_kk_nn+mersMnn] ^ (mers_y_nn >> 1) ^ mers_mag01[mers_y_nn & 0x1UL];
        }
        for (; mers_kk_nn<mersNnn-1; mers_kk_nn++)
        {
            mers_y_nn = (mers_mt_nn[mers_kk_nn]&mersUPPER_MASK)|(mers_mt_nn[mers_kk_nn+1]&mersLOWER_MASK);
            mers_mt_nn[mers_kk_nn] = mers_mt_nn[mers_kk_nn+(mersMnn-mersNnn)] ^ (mers_y_nn >> 1) ^ mers_mag01[mers_y_nn & 0x1UL];
        }
        mers_y_nn = (mers_mt_nn[mersNnn-1]&mersUPPER_MASK)|(mers_mt_nn[0]&mersLOWER_MASK);
        mers_mt_nn[mersNnn-1] = mers_mt_nn[mersMnn-1] ^ (mers_y_nn >> 1) ^ mers_mag01[mers_y_nn & 0x1UL];

        mers_mti_nn = 0;
    }

    mers_y_nn = mers_mt_nn[mers_mti_nn++];

    /* Tempering */
    mers_y_nn ^= (mers_y_nn >> 11);
    mers_y_nn ^= (mers_y_nn << 7) & 0x9d2c5680UL;
    mers_y_nn ^= (mers_y_nn << 15) & 0xefc60000UL;
    mers_y_nn ^= (mers_y_nn >> 18);

    return mers_y_nn;
}

/* generates a random number on [0,1]-real-interval */
double mers_genrand_real1(void)
{
    return mers_genrand_int32()*(1.0/4294967295.0);
    /* divided by 2^32-1 */
}

/* generates a random number on [0,1) with 53-bit resolution*/
double mers_genrand_res53(void)
{
    unsigned long a=mers_genrand_int32()>>5, b=mers_genrand_int32()>>6;
    return(a*67108864.0+b)*(1.0/9007199254740992.0);
}
/* These real versions are due to Isaku Wada, 2002/01/09 added */

/*see http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/MT2002/CODES/mt19937ar.c*/

//end of mersenne twister code
