#include "Entity.h"
#include "Component.h"

void Entity::Update()
{
	for (auto it : componentMap)
	{
		it.second->Update();
	}
}

void Entity::Draw()
{
	for (auto it : componentMap)
	{
		it.second->Draw();
	}
}

void Entity::Add(Component *component)
{
	componentMap[std::type_index(typeid(*component))] = component;
	component->entity = this;
}

Entity::~Entity()
{
	for (auto it : componentMap)
	{
		delete it.second;
	}
}