#ifndef COMPONENT_H
#define COMPONENT_H

#include "Entity.h"

class Component
{
private:
	Entity *entity;
public:
	template <class T>
	T *Get()
	{
		return reinterpret_cast<T *>(entity->componentMap[std::type_index(typeid(T))]);
	}
	virtual void Update() { }
	virtual void Draw() { }
	virtual ~Component() = 0;
	friend class Entity;
};

#endif
