#include <allegro5/allegro.h> 
#include <allegro5/allegro_image.h> 
#include <allegro5/allegro_font.h> 
#include <stdio.h> 

ALLEGRO_SHADER* create_shader()
{
	ALLEGRO_SHADER* shader = al_create_shader(ALLEGRO_SHADER_AUTO);
	if(!al_attach_shader_source(shader, ALLEGRO_VERTEX_SHADER, al_get_default_shader_source(ALLEGRO_SHADER_AUTO, ALLEGRO_VERTEX_SHADER)))
	{
		printf("%s\n", al_get_shader_log(shader));
		return NULL;
	}
	if(!al_attach_shader_source_file(shader, ALLEGRO_PIXEL_SHADER, al_get_shader_platform(shader) == ALLEGRO_SHADER_GLSL ? "coverage_pixel.glsl" : "coverage_pixel.hlsl"))
	{
		printf("%s\n", al_get_shader_log(shader));
		return NULL;
	}
	if(!al_build_shader(shader))
	{
		printf("%s\n", al_get_shader_log(shader));
		return NULL;
	}
	return shader;
}

int main()
{
	al_init();
	al_init_image_addon();
	al_init_font_addon();

	al_set_new_display_flags(ALLEGRO_RESIZABLE | ALLEGRO_PROGRAMMABLE_PIPELINE | ALLEGRO_GENERATE_EXPOSE_EVENTS);
	ALLEGRO_DISPLAY* d = al_create_display(800, 600);
	assert(d);
	
	al_install_keyboard();
	
	ALLEGRO_EVENT_QUEUE* q = al_create_event_queue();
	al_register_event_source(q, al_get_display_event_source(d));
	al_register_event_source(q, al_get_keyboard_event_source());
	
	ALLEGRO_FONT* font = al_create_builtin_font();
	
	int bmp_idx = 0;
	ALLEGRO_BITMAP* bmps[2];
	bmps[0] = al_load_bitmap("metroid.png");
	assert(bmps[0]);
	bmps[1] = al_load_bitmap("test.png");
	assert(bmps[1]);

	ALLEGRO_BITMAP* linear_bmps[2];
	al_set_new_bitmap_flags(ALLEGRO_MAG_LINEAR | ALLEGRO_MIN_LINEAR);
	linear_bmps[0] = al_clone_bitmap(bmps[0]);
	linear_bmps[1] = al_clone_bitmap(bmps[1]);
	
	ALLEGRO_SHADER* shader = create_shader();
	assert(shader);
	
	int method = 0;
	const char* method_names[3] = {"Shader", "Nearest", "Linear"};
	
	bool redraw = true;
	bool quit = false;
	while(!quit)
	{
		if(redraw && al_is_event_queue_empty(q))
		{
			ALLEGRO_BITMAP* bmp;
			if(method == 0 || method == 1)
				bmp = bmps[bmp_idx];
			else if(method == 2)
				bmp = linear_bmps[bmp_idx];
			al_clear_to_color(al_map_rgb_f(0, 0, 0));
			int bw = al_get_bitmap_width(bmp);
			int bh = al_get_bitmap_height(bmp);
			int dw = al_get_display_width(d);
			int dh = al_get_display_height(d);
			float scale_w = (float)dw / bw;
			float scale_h = (float)dh / bh;
			float scale = scale_w < scale_h ? scale_w : scale_h;
			
			if(method == 0)
			{
				al_use_shader(shader);
				al_set_shader_float("bitmap_width", bw);
				al_set_shader_float("bitmap_height", bh);
				al_set_shader_float("x_scale", scale);
				al_set_shader_float("y_scale", scale);
			}
			else
			{
				al_use_shader(NULL);
			}
			
			al_draw_scaled_bitmap(bmp, 0, 0, bw, bh, 0, 0, scale * bw, scale * bh, 0);
			
			al_use_shader(NULL);
			
			al_draw_textf(font, al_map_rgb_f(0, 1, 0), 10, 10, 0, "Left/Right - Switch drawing method (now using %s)", method_names[method]);
			al_draw_text(font, al_map_rgb_f(0, 1, 0), 10, 20, 0, "B - Toggle bitmap");
			
			al_flip_display();
			redraw = false;
		}
		
		ALLEGRO_EVENT ev;
		al_wait_for_event(q, &ev);
		switch(ev.type)
		{
			case ALLEGRO_EVENT_DISPLAY_EXPOSE:
				redraw = true;
				break;
			case ALLEGRO_EVENT_DISPLAY_RESIZE:
				al_destroy_shader(shader);
				al_acknowledge_resize(ev.display.source);
				shader = create_shader();
				redraw = true;
				break;
			case ALLEGRO_EVENT_DISPLAY_CLOSE:
				quit = true;
				break;
			case ALLEGRO_EVENT_KEY_DOWN:
				switch(ev.keyboard.keycode)
				{
					case ALLEGRO_KEY_LEFT:
						method = method - 1;
						if(method < 0)
							method = 2;
						break;
					case ALLEGRO_KEY_RIGHT:
						method = (method + 1) % 3;
						break;
					case ALLEGRO_KEY_B:
						bmp_idx = 1 - bmp_idx;
						break;
					case ALLEGRO_KEY_ESCAPE:
						quit = true;
						break;
				}					
				redraw = true;
				break;
      }
	}
}
