/**\file santasledrace.c
*
*  SantaSledRace function file for SantaHack 2012
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 20/12/2012
*
*/



#include "main.h"



int proceed_santasledrace( GAME_ENV **game , int *DONE )
{
	BITMAP *tree = NULL ,
			*santa[ 4 ] = { NULL , NULL , NULL , NULL } ,
			*reindeer[ 4 ] = { NULL , NULL , NULL , NULL  } ,
			*christmas_ball = NULL ,
			*canonball = NULL ,
			*snow = NULL ;

	int Floors[ 200 ][ 3 ] ,
		collision_point[2] , collide = 0 ,
		x1 = 0 , y1 = 0 , x2 = 0 , y2 = 0 ,
		it = 0 , it1 = 0 , direction = 0 ,
		clicked = 0 , jumping = 0;		

	double angle = 0 , itx = 0 , ity = 0 , ax = 0 , ay = 0 ,droptime = 0 , level_start = 5000000 , anim_loop = 1000 ;
	

	
	PARTICLE *p_iter_1 = NULL ;
	PARTICLE *p_iter_2 = NULL ;
	
	PHYSICS santa_object , tmp_part ;	

	PARTICLE_SYSTEM *starfield = NULL ,
					*little_snow = NULL ,
					*mad_christmas_balls = NULL ,
					*bullets = NULL ,
					*FX = NULL ,
					*power_up = NULL ;
	
	PMASK 	*christmasballmask = NULL ,
			*canonballmask = NULL ,
			*santamask[4] = { NULL , NULL , NULL , NULL } ,
			*reindeermask[ 4 ] = { NULL , NULL , NULL , NULL } ;
			
	SAMPLE *shoot = load_sample("DATA/SOUNDS/shoot.wav");
	if (!shoot)
	{
		allegro_message("Couldn't load sample shoot.wav!");
		exit( 1 );
	}

	SAMPLE *busted = load_sample("DATA/SOUNDS/busted.wav");
	if (!busted)
	{
		allegro_message("Couldn't load sample shoot.wav!");
		exit( 1 );
	}

	tree = load_bitmap( "DATA/GFX/Tree.bmp" , NULL );
	
	santa[0] = load_bitmap( "DATA/GFX/Santa.bmp" , NULL );
	santa[2] = load_bitmap( "DATA/GFX/santafight.bmp" , NULL );
	
	santa[1] = create_bitmap( santa[ 0 ] -> w , santa[ 0 ] -> h );
	clear_to_color( santa[ 1 ] , makecol( 255  , 0 , 255 ) );
	draw_sprite_h_flip( santa[ 1 ] , santa[ 0 ] , 0 , 0 );
	
	santa[3] = create_bitmap( santa[ 2 ] -> w , santa[ 2 ] -> h );
	clear_to_color( santa[ 3 ] , makecol( 255  , 0 , 255 ) );
	draw_sprite_h_flip( santa[ 3 ] , santa[ 2 ] , 0 , 0 );

	reindeer[0] = load_bitmap( "DATA/GFX/renne.bmp" , NULL );
	reindeer[1] = load_bitmap( "DATA/GFX/renne2.bmp" , NULL );
	
	reindeer[2] = create_bitmap( reindeer[ 0 ] -> w , reindeer[ 0 ] -> h );
	clear_to_color( reindeer[ 2 ] , makecol( 255  , 0 , 255 ) );
	draw_sprite_h_flip( reindeer[ 2 ] , reindeer[ 0 ] , 0 , 0 );
	
	reindeer[3] = create_bitmap( reindeer[ 1 ] -> w , reindeer[ 1 ] -> h );
	clear_to_color( reindeer[ 3 ] , makecol( 255  , 0 , 255 ) );
	draw_sprite_h_flip( reindeer[ 3 ] , reindeer[ 1 ] , 0 , 0 );
	
	christmas_ball = load_bitmap( "DATA/GFX/christmas_ball.bmp" , NULL );
	snow = load_bitmap( "DATA/GFX/snow.bmp" , NULL );
	canonball = load_bitmap( "DATA/GFX/canonballmini.bmp" , NULL );
	
	VECTOR4D_SET( santa_object . position ,  SCREEN_W / 2 - santa[ 0 ] -> w / 2 , SCREEN_H - santa[ 0 ] -> h , 0.0 , 0 );
	VECTOR4D_SET( santa_object . speed , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( santa_object . acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( santa_object . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( santa_object . angular_speed , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( santa_object . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );

	init_particle_system( &little_snow , 100  , 0 , 0 , 0);
	init_particle_system( &mad_christmas_balls , 100  ,  0 , 0 , 0 );
	init_particle_system( &bullets , 500  , 0 , 0 , 0 );
	init_particle_system( &FX , 500  , 0 , 0 , 0 );
	init_particle_system( &power_up , 500  , 0 , 0 , 0 );
	init_particle_system( &starfield , 100 , 0 , 0 , 0 );
	

	christmasballmask = create_allegro_pmask( christmas_ball );
	canonballmask = create_allegro_pmask( canonball );
	for( it = 0 ; it < 4 ; it ++ )
	{
		santamask[ it ] = create_allegro_pmask( santa[ it ] );
		reindeermask[ it ] = create_allegro_pmask( reindeer[ it ] );
	}
			
			
			
	/* floors */
	int y = SCREEN_H ;
	for( it = 0 ; it < 200 ; it ++ )
	{
		Floors[ it ][ 0 ] = 10 + rand()%(SCREEN_H - 10) ; //x
		Floors[ it ][ 1 ] = y - 100 - rand()% 100 ; //y
		Floors[ it ][ 2 ] = 50 + 50*rand()%(SCREEN_H - 100 ); //size
		y = Floors[ it ][ 1 ] ;
	}
			
			
	/* GAME LOOP */
	start_HiTimer( &(*game) ->game_timer );
	
	/* fill the screen with some snow */
	for( it = 0 ; it < 100 ; it ++ )
	{
		VECTOR4D_SET( tmp_part . speed , ( 2000 - rand()%4000 )/ 100.0 , ( 2000 + rand()%4000 )/ 100.0 , 0 , 0 );
		VECTOR4D_SET( tmp_part . angular_speed , 0.0 , 0.0 , ( 2000 - rand()%4000 )/ 10.0 , 0.0 );
		VECTOR4D_SET( tmp_part . position , rand()% SCREEN_W , rand()%SCREEN_H , 0.0 , 0 );
		VECTOR4D_SET( tmp_part . acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
		VECTOR4D_SET( tmp_part . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
		VECTOR4D_SET( tmp_part . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
		add_particle( little_snow , snow , SNOW_PART , -1 , 0 , tmp_part );
		VECTOR4D_SET( tmp_part . speed , ( tmp_part . position[ 0 ] - SCREEN_W / 2 ) / 100.0 , ( tmp_part . position[ 1 ] - SCREEN_H / 2 ) / 100.0 , 0.0 , 0.0 ); 
		add_particle( FX , NULL , STAR_PART , -1 , makecol( 200 + rand()%55 , 200 + rand()%55  , 200 + rand()%55 ) , tmp_part );
	}
	
	
	
	
	int scroll = 0 , last_scroll = 0 , delta_scroll = 0 ;
	
	santa_object . position[ 0 ] = Floors[ 0 ][ 0 ];
	santa_object . position[ 1 ] = SCREEN_H / 2 - reindeer[ 0 ] -> h ;
	
			
	
	do
	{
		(*game) -> loop_time   = get_usec( &(*game) -> game_timer );
		(*game) -> draw_time  -= (*game) -> loop_time;
		(*game) -> logic_time -= (*game) -> loop_time;

		/* TODO DISPLAY SOMETHING WHILE WAITING */
		/* five seconds before start */
		if( level_start > 0 )
			level_start -= (*game) -> loop_time;

		droptime -= (*game) -> loop_time;
		if( santa_object . speed[ 0 ] != 0 )
			anim_loop -= (*game) -> loop_time;

		if( (*game) -> logic_time <= 0 )
		{
			while( (*game) -> logic_time <= 0)
				(*game) -> logic_time += (*game) -> LOGIC_RATE ;

			if( (*game) -> wait_for_slowing_down_cpu == 0 )
				(*game) -> wait_for_slowing_down_cpu = 1;

			if( droptime < 0 )
			{
				VECTOR4D_SET( tmp_part . position ,  50 + rand()%( SCREEN_W/2 - 100 ) , -10.0 , 0.0 , 0.0 );
				VECTOR4D_SET( tmp_part . speed , 10 - rand()%20 , 15 + rand()%30 , 0.0 , 0.0 );
				VECTOR4D_SET( tmp_part . acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
				VECTOR4D_SET( tmp_part . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
				VECTOR4D_SET( tmp_part . angular_speed , 0.0 , 0.0 , 5.0 , 0.0 );
				VECTOR4D_SET( tmp_part . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
				add_particle( mad_christmas_balls , christmas_ball , NORMAL_PART , 10000 , 0 , tmp_part );
				droptime = 1000000 ; 
			}
			
			for( it = 0 ; it < 3 ; it ++ )
			{
				santa_object . speed[ it ] = santa_object . speed[ it ] + (santa_object . acceleration[ it ] * (*game) -> LOGIC_RATE ) /1000 ;
				santa_object . position[ it ] = santa_object . position[ it ] + ( santa_object . speed[ it ] * (*game) -> LOGIC_RATE ) / 1000 + ( 0.5 *  santa_object . acceleration[ it ] * (*game) -> LOGIC_RATE * (*game) -> LOGIC_RATE) /1000;
			}
			
			if( santa_object . position[ 1 ] < SCREEN_H / 2 )
			{
				last_scroll = scroll ;
				
				if( (tree -> h - (*game) -> scrbuf -> h + scroll) > 0 )
				{
					scroll += santa_object . position[ 1 ] - SCREEN_H / 2 ;
					santa_object . position[ 1 ] = SCREEN_H / 2 ;
				}
				
				while( (tree -> h - (*game) -> scrbuf -> h + scroll) < 0 )
						scroll ++ ;
							
				delta_scroll = last_scroll - scroll ;
			}
			else
				delta_scroll = 0 ;
			
			santa_object . acceleration[ 1 ] = 0.00037 ;
			int on_a_block = 0 ;
			for( it = 0 ; it < 200 ; it ++ )
			{
				
				if( (santa_object . position[ 0 ] + santa[ 0 ] -> w ) > Floors[ it ][ 0 ] && ( santa_object . position[ 0 ] < ( Floors[ it ][ 0 ] + Floors[ it ][ 2 ]  ) ) &&
					(santa_object . position[ 1 ] + reindeer[ 0 ] -> h ) >= (Floors[ it ][ 1 ]-scroll) && ( santa_object . position[ 1 ] + reindeer[ 0 ] -> h ) < ( Floors[ it ][ 1 ]-scroll + 20 ) )
				{
					santa_object . position[ 1 ] = 	Floors[ it ][ 1 ] - reindeer[ 0 ] -> h - scroll   ;
					santa_object . speed[ 1 ] = 0 ;
					santa_object . acceleration[ 1 ] = 0 ;
					jumping = 0 ; 
				}
				
			}
			
			 if( key[KEY_Y] )
				scroll -- ;
			if( key[KEY_U] )
				scroll ++ ;
			
			
			if( key[KEY_S] && key[KEY_T])
			{
				while( key[KEY_S] ||key[KEY_T]){};
				(*game) -> level = 5 ;
			}

			santa_object . speed[ 0 ] = 0 ;
			if( key[ KEY_LEFT ] )
			{
				santa_object . speed[ 0 ] = -0.3 ;
				direction = 0 ;
			}			
			if( key[ KEY_RIGHT ] )
			{
				santa_object . speed[ 0 ] = 0.3 ;
				direction = 1;
			}
			
			if( key[ KEY_UP ] && jumping == 0 )
			{
				santa_object . speed[ 1 ] = -3.5 ;
				
				jumping = 1 ;
			}
									
			if( santa_object . position[ 0 ] < 0 )
			{	
				santa_object . position[ 0 ] = 0 ;
			}
			if( santa_object . position[ 0 ] > ( SCREEN_W -  reindeer[ 0 ] -> w ) )
			{
				santa_object . position[ 0 ] = ( SCREEN_W -  reindeer[ 0 ] -> w ) ;
			}
			if( santa_object . position[ 1 ] >  (SCREEN_H - reindeer[ 0 ]->h) )
			{
				santa_object . position[ 1 ] = (SCREEN_H - reindeer[ 0 ]->h);
				jumping = 0 ;
			}
			
			
			p_iter_1 = little_snow -> list_start ;
			while( p_iter_1 )
			{
				p_iter_1 -> object . position[ 1 ] += delta_scroll ;
				p_iter_1 = p_iter_1 -> next ;
			}
			p_iter_1 = bullets -> list_start ;
			while( p_iter_1 )
			{
				p_iter_1 -> object . position[ 1 ] += delta_scroll ;
				p_iter_1 = p_iter_1 -> next ;
			}
			p_iter_1 = mad_christmas_balls -> list_start ;
			while( p_iter_1 )
			{
				p_iter_1 -> object . position[ 1 ] += delta_scroll ;
				p_iter_1 = p_iter_1 -> next ;
			}
			p_iter_1 = FX -> list_start ;
			while( p_iter_1 )
			{
				p_iter_1 -> object . position[ 1 ] += delta_scroll ;
				p_iter_1 = p_iter_1 -> next ;
			}
			
			manage_particle( little_snow );
			manage_particle( bullets );
			manage_particle( mad_christmas_balls );
			manage_particle( FX );
			
			if( clicked >= 0 )
				clicked = clicked - (*game) -> logic_time ;

			if( mouse_b&1 )
			{
				if( clicked < 0 )
				{
					play_sample(shoot, 255, 128, 1000, 0);

					(*game) -> shooted ++ ;

					itx = (double)(mouse_x - ( santa_object . position[ 0 ] ) );
					ity = (double)(mouse_y - ( santa_object . position[ 1 ] ) );
					
					add_particle_ex( bullets , canonball , NORMAL_PART , santa_object . position[ 0 ] , santa_object . position[ 1 ] , 10000 , makecol( 240 + rand()%15 , 240 + rand()%15 , 240 + rand()%15 ) ,
					itx, ity , 0 ,
					0 , 0 , 0 );
					
					clicked = 30000 ;
				}
			}
			else
			{
				if( !mouse_b&1)
				{
					clicked = 0 ;
				}
			}
			(*game) -> wait_for_slowing_down_cpu = 1 ;
		} /* if( logic_time ... ) */


		if( (*game) -> draw_time <= 0 )
		{
			while( (*game) -> draw_time <= 0 )
				(*game) -> draw_time += (*game) -> GFX_UPDATE_RATE ;

			if( (*game) -> BLUR == 1 )
			{
				drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
				set_alpha_blender();
				rectfill( (*game) -> scrbuf , 0 , 0 , (*game) -> scrbuf -> w , (*game) -> scrbuf -> h , makeacol( 0 , 0 , 0 , (*game) -> fade_value ));
				drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
			}
			else
				clear( (*game) -> scrbuf );
				
				
			masked_stretch_blit( tree , (*game) -> scrbuf , tree -> w /2 - (*game) -> scrbuf -> w / 2 , tree -> h - (*game) -> scrbuf -> h + scroll,(*game) -> scrbuf -> w , (*game) -> scrbuf -> h , 0 , 0 , (*game) -> scrbuf -> w , (*game) -> scrbuf -> h );
						
			for( it = 0 ; it < 200 ; it ++ )
			{
				if( (Floors[ it ][ 1 ]-scroll) > 0 && (Floors[ it ][ 1 ]-scroll) < SCREEN_H )
				{
					rectfill( (*game) -> scrbuf ,  Floors[ it ][ 0 ] ,  Floors[ it ][ 1 ]-scroll ,  Floors[ it ][ 0 ] +  Floors[ it ][ 2 ] ,  Floors[ it ][ 1 ]-scroll + 20 , makecol( 25 , 240 , 10 ) );  
					rectfill( (*game) -> scrbuf ,  Floors[ it ][ 0 ] + 5 ,  Floors[ it ][ 1 ]-scroll + 5 ,  Floors[ it ][ 0 ] +  Floors[ it ][ 2 ] - 5 ,  Floors[ it ][ 1 ]-scroll + 15 , makecol( 0 , 200 , 0 ) );  
				}
			}
						
			draw_particle( (*game) -> scrbuf , little_snow );
			draw_particle( (*game) -> scrbuf , starfield );
			draw_particle( (*game) -> scrbuf , mad_christmas_balls );
			draw_particle( (*game) -> scrbuf , FX );
			draw_particle( (*game) -> scrbuf , power_up );
			draw_particle( (*game) -> scrbuf , bullets );
			
			masked_blit( santa[ direction ] , (*game) -> scrbuf , 0 , 0 , santa_object . position[ 0 ] , santa_object . position[ 1 ] - 30, santa[ direction ] -> w , santa[ direction ] -> h );
			
			if( anim_loop < 50000 )
				masked_blit( reindeer[ 2*direction ] , (*game) -> scrbuf , 0 , 0 , santa_object . position[ 0 ] , santa_object . position[ 1 ], reindeer[ direction ] -> w , reindeer[ direction ] -> h );
			else
				masked_blit( reindeer[ 1 + 2*direction ] , (*game) -> scrbuf , 0 , 0 , santa_object . position[ 0 ] , santa_object . position[ 1 ], reindeer[ direction ] -> w , reindeer[ direction ] -> h );
			if( anim_loop < 0 )
				anim_loop += 100000 ;

			textprintf_ex( (*game) -> scrbuf , font , 2, 2 , makecol( 255 , 10 , 0) , -1 ,
			"Score: %d , Lifes: %d, Level: %d" , (*game) -> score , (*game) -> lifes , (*game) -> level ) ;
			if( (*game) -> shooted > 0 )
			{
			textprintf_ex( (*game) -> scrbuf , font , 2, 13 , makecol( 255 , 10 , 0) , -1 ,
			"Shots:%d , Busted: %d , %d %%" , (*game) -> shooted , (*game) -> busted  , (100 * (*game) -> busted )/(*game) -> shooted)   ;
			}
			line( (*game) -> scrbuf , mouse_x -10 , mouse_y , mouse_x + 10 , mouse_y , makecol( 255 , 0 , 0 ));
			line( (*game) -> scrbuf , mouse_x , mouse_y-10 , mouse_x  , mouse_y +10, makecol( 255 , 0 , 0 ));
			circle( (*game) -> scrbuf , mouse_x , mouse_y , 6 , makecol( 255 , 0 , 0 ) );

			if( level_start > 0 )
			{
				 textprintf_centre_ex( (*game) -> scrbuf , font , SCREEN_W/2, SCREEN_H/2 , makecol( 255 , 10 , 0) , -1 ,
			"LEVEL %d ! AIM WITH MOUSE ,CLICK FOR FIRE, MOVE WITH ARROW KEYS !" , (*game) -> level )   ;

			}
		

			rectfill( (*game) -> scrbuf , SCREEN_W-22 , 30 , SCREEN_W-10 , SCREEN_H-155 , makecol( 0 , 0 , 255 ));
			rectfill( (*game) -> scrbuf , SCREEN_W-18 , SCREEN_H-160-4*(*game)->lifes , SCREEN_W-12 , SCREEN_H-160 , makecol( 255 , 0 , 0 ));

			if( (*game) -> level < 10 )
				it = ((*game) -> busted * 100 ) /(((*game) -> level + 1 ) * 15 );
			else
				it = ((*game) -> busted * 100 ) /700;


			it = (it * ( SCREEN_H -155-30 )) / 100 ;
			rectfill( (*game) -> scrbuf , SCREEN_W-22 , SCREEN_H -155 , SCREEN_W-32 , SCREEN_H -155- it , makecol( 255 , 255 , 0 ));



			blit( (*game) -> scrbuf , screen ,0 , 0  , 0 , 0 , (*game) -> scrbuf -> w , (*game) -> scrbuf -> h );

			if( gfx_status( GET , 0 ) == MODE_OGL )
			{
				allegro_gl_flip();
			}

		   (*game) -> wait_for_slowing_down_cpu = 1 ;
		   
		}

		if( (*game) -> wait_for_slowing_down_cpu == 1 && ( (*game) -> CPU_MODE != CPU_USE_FULL ) )
		{
			(*game) -> wait_for_slowing_down_cpu = 0;
			rest( (*game) -> CPU_MODE );
		}
		else
			rest( 1 );
		
	}while( !key[ KEY_ESC ] && !(*DONE) );

	destroy_bitmap( tree );
	destroy_bitmap( santa[ 0 ] );
	destroy_bitmap( santa[ 1 ] );
	destroy_bitmap( santa[ 2 ] );
	destroy_bitmap( santa[ 3 ] );
	
	destroy_bitmap( snow );
	destroy_bitmap( canonball );
	

	destroy_pmask( christmasballmask );
	destroy_pmask( canonballmask );
	destroy_pmask( santamask[ 0 ] );
	destroy_pmask( santamask[ 1 ] );
	destroy_pmask( santamask[ 2 ] );
	destroy_pmask( santamask[ 3 ] );
	

	destroy_sample( shoot );
	destroy_sample( busted );

	free_particle_system( &mad_christmas_balls );
	free_particle_system( &little_snow );
	free_particle_system( &bullets );
	free_particle_system( &FX );
	

	 return 1 ;

}
