/**\file particle.h
*
*  particle header file for SantaHack 2012
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 20/12/2012
*
*/



#ifndef PARTICLE_HEADER_FOR_SANTAHACK
    #define PARTICLE_HEADER_FOR_SANTAHACK

    #ifdef __cplusplus
       extern "C" {
    #endif

	#include "main.h"

	#define NORMAL_PART 0
	#define SINUS_PART 1
    #define TRANS_PART 2
	#define SNOW_PART 3
	#define FIRE_PART 4
	#define STAR_PART 5
	
	typedef double VECTOR4D[ 4 ]; 
	
	#define VECTOR4D_SET( VECTOR , X , Y , Z , W ) \
		VECTOR[ 0 ] = (X) ; \
		VECTOR[ 1 ] = (Y) ; \
		VECTOR[ 2 ] = (Z) ; \
		VECTOR[ 3 ] = (W) ; 
		
	
	typedef struct PHYSICS
	{
		VECTOR4D 	position ,
					speed ,
					acceleration ,
					orientation ,
					angular_speed ,
					angular_acceleration ;	   
	} PHYSICS ;

	typedef struct PARTICLE
	{
		int mode ,
			lifetime ,
			color;
			
		PHYSICS object ;

    	 BITMAP *sprite ;

		struct PARTICLE *next ,
				 *prev ;

	} PARTICLE ;

	typedef struct PARTICLE_SYSTEM
	{
		PARTICLE *list_start , *list_end ;

		VECTOR4D source ;
		
		N_TIME timer ;

		int max_particles,
			nb_particles ;

	}PARTICLE_SYSTEM ;

	int init_particle_system( PARTICLE_SYSTEM **psys , int max , double x , double y , double z );

	int add_particle( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int lifetime , int color , PHYSICS object );					  
	int add_particle_ex( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int off_x , int off_y , int lifetime , int color ,
					  double vx , double vy , double vz ,
					  double ax , double ay , double az );
	
	int manage_particle( PARTICLE_SYSTEM *psys);

	int draw_particle( BITMAP *bmp , PARTICLE_SYSTEM *psys );

	int free_particle( PARTICLE_SYSTEM *psys , PARTICLE **ptr );

	int free_particle_system( PARTICLE_SYSTEM **psys);

	#ifdef __cplusplus
		}
	#endif
#endif /* PARTICLE_HEADER_FOR_CHRISTMASHACK */

