/**\file particle.c
*
*  particle function file for SantaHack 2012
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 20/12/2012
*
*/

#include "main.h"

int init_particle_system( PARTICLE_SYSTEM **psys , int max , double x , double y , double z )
{
	Malloc( (*psys) , PARTICLE_SYSTEM , 1 );

	(*psys) -> list_start = (*psys) -> list_end = NULL ;

	start_HiTimer( &(*psys) -> timer );

	(*psys) -> max_particles = max ;
	(*psys) -> nb_particles  = 0 ;
	(*psys) -> source[ 0 ] = x ;
	(*psys) -> source[ 1 ] = y ;
	(*psys) -> source[ 2 ] = z ;
	(*psys) -> source[ 3 ] = 0 ;

}

int add_particle( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int lifetime , int color , PHYSICS object )
{
	int it = 0 ;
	
	if( psys -> max_particles != -1 )
	{
		if( psys -> nb_particles >= psys -> max_particles )
			return FALSE ;
		psys -> nb_particles ++ ;
	}
	
	for( it = 0 ; it < 3 ; it ++ )
	{
		object . position[ it ] += psys -> source[ it ] ;	
	}
	

	if( !psys -> list_start ) /* no particles */
	{
		Malloc( psys -> list_start , PARTICLE , 1 );

		psys -> list_start -> prev = psys -> list_start -> next = NULL ;
		psys -> list_end = psys -> list_start ;

		psys -> list_start -> sprite = spr ;
		psys -> list_start -> mode = mode ;
		psys -> list_start -> lifetime = lifetime ;
		psys -> list_start -> color = color ;
		
		memcpy( psys -> list_start -> object . position , object . position , sizeof( VECTOR4D ) );
		memcpy( psys -> list_start -> object . speed , object . speed , sizeof( VECTOR4D ) );
		memcpy( psys -> list_start -> object . acceleration , object . acceleration , sizeof( VECTOR4D ) );
		memcpy( psys -> list_start -> object . angular_speed , object . angular_speed , sizeof( VECTOR4D ) );
		memcpy( psys -> list_start -> object . angular_acceleration , object . angular_acceleration , sizeof( VECTOR4D ) );
		memcpy( psys -> list_start -> object . orientation , object . orientation , sizeof( VECTOR4D ) );
		
		return TRUE;
	}

	Malloc( psys -> list_end -> next , PARTICLE , 1 );
	
	psys -> list_end -> next -> prev = psys -> list_end ;
	psys -> list_end -> next -> next = NULL ;
	psys -> list_end = psys -> list_end -> next ;
	
	psys -> list_end -> sprite = spr ;
	psys -> list_end -> mode = mode ;
	psys -> list_end -> lifetime = lifetime ;
	psys -> list_end -> color = color ;
	
	memcpy( psys -> list_end -> object . position , object . position , sizeof( VECTOR4D ) );
	memcpy( psys -> list_end -> object . speed , object . speed , sizeof( VECTOR4D ) );
	memcpy( psys -> list_end -> object . acceleration , object . acceleration , sizeof( VECTOR4D ) );
	memcpy( psys -> list_end -> object . angular_speed , object . angular_speed , sizeof( VECTOR4D ) );
	memcpy( psys -> list_end -> object . angular_acceleration , object . angular_acceleration , sizeof( VECTOR4D ) );
	memcpy( psys -> list_end -> object . orientation , object . orientation , sizeof( VECTOR4D ) );
		
	return TRUE ;

}

int add_particle_ex( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int off_x , int off_y , int lifetime , int color ,
					  double vx , double vy , double vz ,
					  double ax , double ay , double az )
{
	PHYSICS object ;
	VECTOR4D_SET( object . position , off_x  , off_y , 0.0 , 0.0 );
	VECTOR4D_SET( object . speed ,  vx , vy , vz , 0.0 );
	VECTOR4D_SET( object . acceleration , ax , ay , az , 0.0 );
	VECTOR4D_SET( object . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( object . angular_speed , 0.0 , 0.0 , 0.0 , 0.0 );
	VECTOR4D_SET( object . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );

	return add_particle( psys , spr , mode , lifetime , color , object );
}


int manage_particle( PARTICLE_SYSTEM *psys)
{
	PARTICLE *ptr = NULL , *next = NULL , *prev = NULL ;
	
	int it = 0 ;
	
	ptr = psys -> list_start ;

	double delta = 0 ;

	delta = get_msec( &psys -> timer ) ;

	while( ptr )
	{
		if( ptr -> lifetime != -1 )		
		{
			ptr -> lifetime -= delta ;
			if( ptr -> lifetime == -1 )
				ptr -> lifetime = 0 ;
		}

		if( ptr -> lifetime > 0 || ptr -> lifetime == -1 )
		{
			for( it = 0 ; it < 3 ; it ++ )
			{
				ptr -> object . speed[ it ] = ptr -> object . speed[ it ] + ( ptr -> object . acceleration[ it ] * delta )/ 1000 ;
				ptr -> object . position[ it ] = ptr -> object . position[ it ] + ( ptr -> object . speed[ it ] * delta ) / 1000 + ( 0.5 *  ptr -> object . acceleration[ it ] * delta * delta ) /1000 ;
			}

			for( it = 0 ; it < 3 ; it ++ )
			{
				ptr -> object . angular_speed[ it ] = ptr -> object . angular_speed[ it ] + ( ptr -> object . angular_acceleration[ it ] * delta ) / 1000 ;
				ptr -> object . orientation[ it ] = ptr -> object . orientation[ it ] + ( ptr -> object . angular_speed[ it ] * delta ) / 1000 + ( 0.5 *  ptr -> object . angular_acceleration[ it ] * delta * delta ) /1000 ;
			}
	
			ptr = ptr -> next ;
		}
		else
		{
			next = ptr -> next ;
			prev = ptr -> prev ;

			if( next )
			{
				if( prev )
					next -> prev = prev ;
				else
				{
					next -> prev = NULL ;
					psys -> list_start = next ;
				}
			}

			if( prev )
			{
				if( next )
					prev -> next = next ;
				else
				{
					prev -> next = NULL ;
					psys -> list_end = prev ;
				}
			}

			Free( ptr );
			psys -> nb_particles -- ;
			if( psys -> nb_particles <= 0 )
                psys -> list_start = psys -> list_end = NULL ;

			ptr = next ;
		}
	}

	return TRUE;
}

int draw_particle( BITMAP *bmp , PARTICLE_SYSTEM *psys )
{
	PARTICLE *ptr = NULL ;

	double x = 0 , y = 0 ;

	ptr = psys -> list_start ;

	while( ptr )
	{
		x = ptr -> object . position[ 0 ] ;
		y = ptr -> object . position[ 1 ] ;
		
		while( ptr -> object . orientation[ 2 ] > 255 )
			ptr -> object . orientation[ 2 ] -= 256 ;
				
		while( ptr -> object . orientation[ 2 ] < 0 )
			ptr -> object . orientation[ 2 ] += 256 ;

		if( ptr -> mode == SINUS_PART )
		{
		    if( ptr -> object . speed[ 0 ] != 0 )
				x = x + ptr -> object . speed[ 0 ] * sin( (ptr -> object . position[ 0 ]/ptr -> object . speed[ 0 ]) ) ;
			else
				x = x + ptr -> object . speed[ 0 ] * sin( ptr -> object . position[ 0 ] );
			if( ptr -> object . speed[ 1 ] != 0 )
				y = y + ptr -> object . speed[ 0 ] * cos( (ptr -> object . speed[ 1 ]/ptr -> object . speed[ 1 ]) ) ;
			else
				y = y + ptr -> object . speed[ 1 ] * sin( ptr -> object . position[ 1 ] ) ;
				
			if( ptr -> sprite )
            {
                rotate_sprite( bmp , ptr -> sprite , x - ptr -> sprite -> w / 2 , y - ptr -> sprite -> h /2 , ftofix( ptr -> object . orientation[ 2 ] ) );
			}
            else
                circle( bmp , x , y , 2 , ptr -> color );
		}

		if( ptr -> mode == TRANS_PART )
		{
		     drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		     set_alpha_blender( );
             draw_trans_sprite( bmp , ptr -> sprite , x - ptr -> sprite -> w / 2 , y - ptr -> sprite -> h /2 );
    	     drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

        }
		
		
		if( ptr -> mode == SNOW_PART )
		{
			if( ptr -> object . position[ 1 ] > bmp -> h )
				ptr -> object . position[ 1 ] = 0;
				
		    rotate_sprite( bmp , ptr -> sprite , x - ptr -> sprite -> w / 2 , y - ptr -> sprite -> h /2 , ftofix( ptr -> object . orientation[ 2 ] ) );
        }		
        
		
		if( ptr -> mode == NORMAL_PART )
        {
            if( ptr -> sprite )
            {
                rotate_sprite( bmp , ptr -> sprite , x - ptr -> sprite -> w / 2 , y - ptr -> sprite -> h /2 , ftofix( ptr -> object . orientation[ 2 ] ) );
			}
            else
                circle( bmp , x , y , 2 , ptr -> color );
        }
		
		if( ptr -> mode == STAR_PART )
		{
			if( ptr -> object . position[ 1 ] > bmp -> h )
				ptr -> object . position[ 1 ] = 0;
			line( bmp , ptr -> object . position[ 0 ] - 2 , ptr -> object . position[ 1 ] , ptr -> object . position[ 0 ] + 2 , ptr -> object . position[ 1 ] , ptr -> color );
			line( bmp , ptr -> object . position[ 0 ] , ptr -> object . position[ 1 ] -3 , ptr -> object . position[ 0 ] , ptr -> object . position[ 1 ] + 3, ptr -> color );
		}

        ptr = ptr -> next ;
	}

	return TRUE;
}

int free_particle( PARTICLE_SYSTEM *psys , PARTICLE **ptr )
{
    PARTICLE *next = NULL , *prev = NULL ;

    next = (*ptr) -> next ;
    prev = (*ptr) -> prev ;

    if( next )
    {
        if( prev )
            next -> prev = prev ;
        else
        {
            next -> prev = NULL ;
            psys -> list_start = next ;
        }
    }

    if( prev )
    {
        if( next )
            prev -> next = next ;
        else
        {
            prev -> next = NULL ;
            psys -> list_end = prev ;
        }
    }

    Free( (*ptr) );

    psys -> nb_particles -- ;

    if( psys -> nb_particles <= 0 )
        psys -> list_start = psys -> list_end = NULL ;

    (*ptr) = next ;

    return TRUE ;
} /* free_particle(...) */



int free_particle_system( PARTICLE_SYSTEM **psys)
{
	PARTICLE *ptr = NULL , *ptr_next = NULL ;

	ptr = (*psys) -> list_start ;

	while( ptr )
	{
		ptr_next = ptr -> next ;
		Free( ptr ) ;
		ptr = ptr_next ;
	}

	Free( (*psys) );

	return TRUE;
}

