/**\file main.h
*
*  SantaSledRace main header file for SantaHack 2012
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 20/12/2012
*
*/

#ifndef SANTA_SLED_RACE_MAIN
	#define SANTA_SLED_RACE_MAIN

	#ifdef __cplusplus
       extern "C" {
    #endif

	#include <nilorea.h>
	#include "math.h"
	#include "pmask.h"
	#include "types.h"
	#include "collist.h"


	#define CPU_USE_FULL -1         /* full use of CPU */
	#define CPU_USE_NICE 0          /* let the other process have some times */
	#define CPU_USE_LESS 10         /* wait more */

	typedef struct GAME_ENV
	{
		int score,
			lifes,
			BLUR ,                    		 /* wanna blur effect ? ( 0 or 1  ) */
			fade_value ,                	 /* alpha value of black blit  ( 20 default ) */
		    DONE ,                         	 /* loop while DONE != 1 */
		    GFX_CONFIG_MODE , 			  	 /* GFX_OPENGL_WINDOWED */
		    CPU_MODE ,          			 /* status of the cpu mode , CPU_USE_FULL by default */
			loop_time ,                      /* time between each loop */
		    draw_time ,                      /* time before updating graphics in usec*/
		    logic_time,                      /* time before a new logic update is done */
		    wait_for_slowing_down_cpu ,      /* =0 for doing nothing, =1 if logic is done, = 2 if drawing is done too */
		    GFX_UPDATE_RATE ,                /* time between two frames  20000 default */
		    LOGIC_RATE ,                     /* time between two logic updates  10000 default*/
		    real_framerate ,
			level,
			position,
			shooted,
			busted;                 /* framerate */

	    long int next_move_delay ;   /* time since next move change when auto */

		/* screen buffer */
		BITMAP *scrbuf ;
		/* TIMER */
		N_TIME game_timer;

		} GAME_ENV ;

		#include "intro.h"
		#include "particle.h"
		#include "santasledrace.h"


	#ifdef __cplusplus
       }
    #endif

#endif
