/**\file intro.c
*
*  Intro function file for SantaHack 2012
*
*\author Castagnier Mickal aka Gull Ra Driel
*
*\version 1.0
*
*\date 20/12/2012
*
*/

#include "main.h"


/*!\fn proceed_intro()
  *
  *\brief Intro function
  *
  *\param bmp Where to draw the intro
  *
  *\return TRUE
  */
int proceed_intro( BITMAP *bmp , int *DONE )
{
	PARTICLE_SYSTEM *snow ;
	PHYSICS object ;
	
	BITMAP *snow_spr[ 2 ] , *textbuf = NULL , *intro_bg = NULL , *add_buff = NULL ;
	POSITION pos[ 35 ];
	int it = 0 ;

	
	init_particle_system( &snow , 1000  , bmp -> w / 2 , -10  , 0);
	
	intro_bg = load_bitmap( "DATA/GFX/background.bmp" , NULL );
	snow_spr[ 0 ] = load_bitmap( "DATA/GFX/snow.bmp" , NULL );
	snow_spr[ 1 ] = load_bitmap( "DATA/GFX/snow2.bmp" , NULL );
	textbuf = create_bitmap( bmp -> w , bmp -> h );
	add_buff = create_bitmap( bmp -> w , bmp -> h );
	clear( add_buff );
	
	for( it = 0 ; it < 35 ; it ++ )
	{
		pos[ it ] . x = bmp -> w /2 ;

		pos[ it ] . y = bmp -> h + 14 * it ;
		
		pos[ it ] . mx = 0 ;
		pos[ it ] . width = 10 ;
		
		// int add_particle( PARTICLE_SYSTEM *psys , BITMAP *spr , int mode , int off_x , int off_y , int lifetime , int color ,
				  // double vx , double vy , double vz ,
				  // double ax , double ay , double az )
		
	}
	for( it = 0 ; it < 100 ; it ++ )
	{	
			VECTOR4D_SET( object . position ,  bmp -> w /2 - rand()% bmp -> w , rand()% bmp -> h , 0.0 , 0 );
			VECTOR4D_SET( object . speed , ( 2000 - rand()%4000 )/ 100.0 , ( 2000 + rand()%4000 )/ 100.0 , 0 , 0 );
			VECTOR4D_SET( object . acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
			VECTOR4D_SET( object . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
			VECTOR4D_SET( object . angular_speed , 0.0 , 0.0 , ( 2000 - rand()%4000 )/ 100.0 , 0.0 );
			VECTOR4D_SET( object . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
			
			add_particle( snow , snow_spr[ ((rand()%100)>50)?0:1 ] , SNOW_PART , 10000 + rand()%10000 , 0 , object );
	}

	do
	{
	
		manage_particle( snow );
		while( snow -> nb_particles < 100 )
		{	
			VECTOR4D_SET( object . position ,  bmp -> w /2 - rand()% bmp -> w , 0 , 0.0 , 0 );
			VECTOR4D_SET( object . speed , ( 2000 - rand()%4000 )/ 100.0 , ( 2000 + rand()%4000 )/ 100.0 , 0 , 0 );
			VECTOR4D_SET( object . acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
			VECTOR4D_SET( object . orientation , 0.0 , 0.0 , 0.0 , 0.0 );
			VECTOR4D_SET( object . angular_speed , 0.0 , 0.0 , ( 2000 - rand()%4000 )/ 100.0 , 0.0 );
			VECTOR4D_SET( object . angular_acceleration , 0.0 , 0.0 , 0.0 , 0.0 );
			
			add_particle( snow , snow_spr[ ((rand()%100)>50)?0:1 ] , SNOW_PART , 10000 + rand()%10000 , 0 , object );
		}
		draw_particle( bmp , snow );
		
		
		clear_to_color( textbuf , makecol( 255, 0, 255) );
		for( it = 0 ; it < 35 ; it ++ )
		{


			pos[ it ] . mx = pos[ it ] . width * sin( ((double)pos[ it ] . y /13) );

			textprintf_centre_ex( textbuf , font , pos[ it ] . mx + pos[ it ] . x - 3, pos[ it ] . y  - 3 , makecol( 100 , 100 , 255  ) , -1 , "%s" , intro_text[ it ] );
					    textprintf_centre_ex( textbuf , font , pos[ it ] . mx + pos[ it ] . x , pos[ it ] . y  , makecol( 255 , 255 , 255 ) , -1 , "%s" , intro_text[ it ] );

			pos[ it ] . y -= 0.3;
		}
		
		if( pos[ 34 ] . y < 250 )
		{
			for( it = 0 ; it < 35 ; it ++ )
			{
				pos[ it ] . x = bmp -> w /2 ;

				pos[ it ] . y = bmp -> h + 14 * it ;
				pos[ it ] . mx = 0 ;
				pos[ it ] . width = 10 ;
			}
		}

		
		blit( intro_bg , add_buff , 0 , 0 , 0 , 0 , intro_bg -> w , intro_bg -> h );
		
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		set_alpha_blender();
		rectfill( bmp , 0 , 0 , bmp -> w , bmp -> h , makeacol( 0 , 0 , 0 , 20 ));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

		set_trans_blender( 128 , 128 , 128 , 128 );
		draw_trans_sprite( add_buff , bmp , 0 , 0 );

		stretch_sprite( add_buff , textbuf , -250 , -500 , bmp -> w + 500 , bmp -> h + 500 );
		
		blit( add_buff , screen , 0 , 0 , 0 , 0 , add_buff -> w , add_buff -> h );

		if( gfx_status( GET , 0 ) == MODE_OGL )
		{
			allegro_gl_flip();
		}

		rest( 10 );

	}while( !key[ KEY_ESC ] && !(*DONE) );

	free_particle_system( &snow );

	destroy_bitmap( snow_spr[ 0 ] );
	destroy_bitmap( snow_spr[ 1 ] );
	
	
	rest( 1000 );

	return TRUE;
} /* proceed_intro(...) */
