package map;

import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameMap implements Serializable {
	private static final long serialVersionUID = 6545234469929723927L;
	private final Tile[][] tileMap;
	private Map<ACTOR_TYPE, Actor> actors;
	private final int sizeX;
	private final int sizeY;

	public GameMap(int x, int y) {
		this.sizeX = x;
		this.sizeY = y;
		this.tileMap = new Tile[y][x];
		for (int _y = 0; _y < y; _y++) {
			for (int _x = 0; _x < x; _x++) {
				this.tileMap[_y][_x] = new Tile();
			}
		}
		this.actors = new HashMap<ACTOR_TYPE, Actor>();
	}

	public Dimension getDimensions() {
		return new Dimension(this.sizeX * Gfx.TILE_SIZE, this.sizeY * Gfx.TILE_SIZE);
	}

	public int getTilesX() {
		return this.sizeX;
	}

	public int getTilesY() {
		return this.sizeY;
	}

	public Tile getTile(int x, int y) {
		if (this.isOutOfBounds(x, y)) {
			System.out.println(x + " " + y);
			return this.tileMap[0][0];
		}
		return this.tileMap[y][x];
	}

	public void setTile(int x, int y, int selectedTile) {
		if (this.isOutOfBounds(x, y)) {
			System.out.println("Error in index");
			return;
		}
		this.tileMap[y][x].setTypeGfx(selectedTile);
	}

	private boolean isOutOfBounds(int x, int y) {
		return x >= this.sizeX || y >= this.sizeY;
	}

	public void save() {
		ObjectOutputStream obj_out = null;
		FileOutputStream f_out = null;
		try {
			// Write to disk with FileOutputStream
			f_out = new FileOutputStream("myMap.data");

			// Write object with ObjectOutputStream
			obj_out = new ObjectOutputStream(f_out);

			// Write object out to disk
			obj_out.writeObject(this);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				f_out.close();
				obj_out.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

	}

	public void addActor(Actor actor) {
		this.actors.put(actor.getActorType(), actor);
	}

	public List<Actor> getActorsInView(int xs, int ys, int wx, int hy) {
		List<Actor> actorsInView = new ArrayList<Actor>();
		for (Actor a : this.actors.values()) {
			int x = a.getPosx();
			int y = a.getPosy();
			if (xs <= x && x <= wx && y >= ys && y <= hy) actorsInView.add(a);
		}
		return actorsInView;
	}

	public void checkStatus() {
		if (this.actors == null) this.actors = new HashMap<ACTOR_TYPE, Actor>();

	}

	public Tile[][] getTileMap() {
		return this.tileMap;
	}

	public Collection<Actor> getActors() {
		return this.actors.values();
	}
}
