package it.fmc.santahack2012.io;


import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;

import map.GameMap;


public class MapLoader {
	public GameMap loadMap() {
		GameMap gmap = null;
		// Read from disk using FileInputStream
		FileInputStream f_in = null;
		ObjectInputStream obj_in = null;
		try {
			f_in = new FileInputStream("myMap.data");
			// Read object using ObjectInputStream
			obj_in = new ObjectInputStream(f_in);

			// Read an object
			Object obj = obj_in.readObject();

			if (obj instanceof GameMap) {
				gmap = (GameMap) obj;
				gmap.checkStatus();
			}
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		} catch (ClassNotFoundException e1) {
			e1.printStackTrace();
		} finally {
			try {
				f_in.close();
				obj_in.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
		return gmap;
	}

}
