package it.fmc.santahack2012.gui;

import it.fmc.santahack2012.astar.PathFinder;
import it.fmc.santahack2012.events.AllyBuilding;
import it.fmc.santahack2012.events.AllyChar;
import it.fmc.santahack2012.events.CharacterFactory;
import it.fmc.santahack2012.events.DIR;
import it.fmc.santahack2012.events.EnemyChar;
import it.fmc.santahack2012.events.EventHelper;
import it.fmc.santahack2012.events.FogOfWar;
import it.fmc.santahack2012.events.Interactable;
import it.fmc.santahack2012.events.InteractableType;
import it.fmc.santahack2012.events.Orc;
import it.fmc.santahack2012.events.STATE;
import it.fmc.santahack2012.events.Santa;
import it.fmc.santahack2012.events.Selectable;
import it.fmc.santahack2012.events.SimpleAnimator;
import it.fmc.santahack2012.gfx.GraphicsHandler;
import it.fmc.santahack2012.io.MapLoader;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

import map.Actor;
import map.GameMap;

public class MainPanel extends JPanel implements Runnable, ComponentListener, KeyListener, MouseListener,
		MouseMotionListener {
	private static final long serialVersionUID = 5293065930469047379L;
	private static final long DELAY = 20;
	private final GameMap gmap;
	private Thread animator;
	private final Camera camera;
	private final GraphicsHandler gfxH;
	private int mx;
	private int my;
	private BufferStrategy strategy;
	private final List<Interactable> interactables;
	private final List<Selectable> selected;
	private final CharacterFactory charF;
	private int lastMouseClick;
	private final PathFinder pathfinder;
	private final FogOfWar fogOfWar;
	private Santa santa;

	public MainPanel() {
		super();

		// game stuff
		gmap = new MapLoader().loadMap();
		gfxH = new GraphicsHandler();
		gfxH.loadData();
		camera = new Camera(gmap, gfxH);
		mx = my = 0;
		interactables = new ArrayList<Interactable>();
		selected = new ArrayList<Selectable>();
		strategy = null;
		List<Integer> solidTiles = new ArrayList<Integer>();
		for (int k = 13; k <= 42; k++)
			solidTiles.add(new Integer(k));
		for (int k = 73; k <= 92; k++)
			solidTiles.add(new Integer(k));
		pathfinder = new PathFinder(gmap, solidTiles);
		List<Interactable> buildings = loadStartingBuildings();
		pathfinder.addBuilding(buildings);
		charF = new CharacterFactory(gfxH, pathfinder);
		fogOfWar = new FogOfWar(gmap);
		lastMouseClick = MouseEvent.NOBUTTON;
		// GUI stuff
		setIgnoreRepaint(false);
		setDoubleBuffered(true);
		addComponentListener(this);
		addKeyListener(this);
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	public void draw(List<Interactable> inScreenActors) {// Graphics g) {
		if (strategy == null) return;
		Graphics g = strategy.getDrawGraphics();
		Graphics2D g2 = (Graphics2D) g;
		camera.render(g2, inScreenActors, fogOfWar);

		Toolkit.getDefaultToolkit().sync();
		g.dispose();
		strategy.show();
	}

	public void handleCamera() {
		if (mouseAtRightEdge())
			camera.panRight();
		else if (mouseAtLeftEdge()) camera.panLeft();
		if (mouseAtTopEdge())
			camera.panUp();
		else if (mouseAtBottomEdge()) camera.panDown();
	}

	private boolean mouseAtRightEdge() {
		int w = getWidth();
		if (mx <= w && mx > (w * 0.85)) return true;
		return false;
	}

	private boolean mouseAtLeftEdge() {
		int w = getWidth();
		if (mx > 0 && mx < (w * 0.15)) return true;
		return false;
	}

	private boolean mouseAtBottomEdge() {
		int h = getHeight();
		if (my <= h && my > (h * 0.85)) return true;
		return false;
	}

	private boolean mouseAtTopEdge() {
		int h = getHeight();
		if (my > 0 && my < (h * 0.15)) return true;
		return false;
	}

	@Override
	public void addNotify() {
		super.addNotify();
		animator = new Thread(this);
		animator.start();
	}

	@Override
	public void run() {
		long beforeTime, timeDiff, sleep;
		beforeTime = System.currentTimeMillis();
		loadCharacters();
		while (true) {
			List<Interactable> inScreenActors = camera.getActorsInScreen(interactables);
			handleMouse(inScreenActors);
			attackSanta(inScreenActors);
			this.update();
			draw(inScreenActors);

			timeDiff = System.currentTimeMillis() - beforeTime;
			sleep = DELAY - timeDiff;

			if (sleep < 0) sleep = 2;
			try {
				Thread.sleep(sleep);
			} catch (InterruptedException e) {
				System.out.println("interrupted");
			}

			beforeTime = System.currentTimeMillis();
		}

	}

	private void attackSanta(List<Interactable> inScreenActors) {
		for (Interactable i : inScreenActors) {
			if (i.getType() == InteractableType.ENEMY) {
				EnemyChar enemy = (EnemyChar) i;
				if (enemy.getState() == STATE.IDLE) enemy.attack(santa);
			}
		}

	}

	private void handleMouse(List<Interactable> inScreenActors) {
		handleCamera();

		if (lastMouseClick == MouseEvent.BUTTON1) {
			for (Selectable s : selected)
				s.setSelected(false);
			selected.clear();
			Selectable active = (Selectable) getSelectedInteractable(inScreenActors);
			if (active != null) {
				active.setSelected(true);
				selected.add(active);
			}
		} else if (lastMouseClick == MouseEvent.BUTTON3) {
			if (!selected.isEmpty()) {
				int absX = mx + camera.getShowX();
				int absY = my + camera.getShowY();
				System.out.println("{" + absX + ", " + absY + "}");
				EnemyChar enemy = getAttackedEnemy(inScreenActors);
				if (enemy != null) {
					for (Selectable i : selected)
						if (i.getType() == InteractableType.ALLY) ((AllyChar) i).attack(enemy);
				} else {
					AllyBuilding building = getBuilding(inScreenActors);
					if (building != null) {
						int house = building.activate();
						if (house == 2) {
							JOptionPane.showMessageDialog(getParent(), "You found one house! Two to go!");
							santa.heal();
						}
						if (house == 3) {
							JOptionPane.showMessageDialog(getParent(),
									"You found two houses! One to go! Sometimes it's better to run from orcs!");
							santa.heal();
						}
						if (house == 1) {
							JOptionPane.showMessageDialog(getParent(),
									"You found three houses! Christmas is saved! You WIN!");
						}
					} else
						for (Selectable i : selected)
							i.moveAtLocation(absX, absY);
				}
			}
		}
		lastMouseClick = MouseEvent.NOBUTTON;
	}

	private AllyBuilding getBuilding(List<Interactable> inScreenActors) {
		AllyBuilding clicked = null;
		for (Interactable in : inScreenActors) {
			if (in.isMouseOn(mx + camera.getShowX(), my + camera.getShowY())
					&& in.getType() == InteractableType.ALLY_BUILDING) {
				clicked = (AllyBuilding) in;
				break;
			}
		}
		return clicked;
	}

	private EnemyChar getAttackedEnemy(List<Interactable> inScreenActors) {
		EnemyChar clicked = null;
		for (Interactable in : inScreenActors) {
			if (in.isMouseOn(mx + camera.getShowX(), my + camera.getShowY()) && in.getType() == InteractableType.ENEMY) {
				clicked = (EnemyChar) in;
				break;
			}
		}
		return clicked;
	}

	private Interactable getSelectedInteractable(List<Interactable> inScreenActors) {
		Interactable clicked = null;
		for (Interactable in : inScreenActors) {
			if (in.isSelectable() && in.isMouseOn(mx + camera.getShowX(), my + camera.getShowY())) {
				clicked = in;
				break;
			}
		}
		return clicked;
	}

	private void loadCharacters() {
		Interactable start = new EventHelper().getStartFactory(interactables);
		santa = charF.getSanta(start.getX() - 90, start.getY() - 60);
		santa.face(DIR.S);
		interactables.add(santa);
		Orc orc = charF.getOrc(start.getX() + 190, start.getY() + 160);
		interactables.add(orc);
		int orcsP[][] = { { 1349, 835 }, { 1934, 759 }, { 2428, 1282 }, { 2995, 2347 }, { 2995, 2247 }, { 2995, 2447 },
				{ 2895, 2347 } };
		for (int k = 0; k < orcsP.length; k++)
			interactables.add(charF.getOrc(orcsP[k][0], orcsP[k][1]));
	}

	private List<Interactable> loadStartingBuildings() {
		for (Actor a : gmap.getActors()) {
			Image img = gfxH.getActor(a.getActorType());
			interactables.add(new AllyBuilding(a.getPosx(), a.getPosy(), img.getWidth(null), img.getHeight(null),
					new SimpleAnimator(img), a.getActorType()));
		}
		return interactables;
	}

	private void update() {
		for (Interactable a : interactables)
			a.update();
		fogOfWar.update(interactables);
	}

	@Override
	public void componentResized(ComponentEvent e) {
		int w = getWidth();
		int h = getHeight();
		camera.setScreenBounds(w, h);
		this.repaint();
	}

	@Override
	public void componentMoved(ComponentEvent e) {
		this.repaint();
	}

	@Override
	public void componentShown(ComponentEvent e) {
		this.repaint();
	}

	@Override
	public void componentHidden(ComponentEvent e) {
		//
	}

	@Override
	public void keyTyped(KeyEvent e) {
		//
	}

	@Override
	public void keyPressed(KeyEvent e) {
		char pressed = e.getKeyChar();
		if (pressed == 'w')
			camera.panUp();
		else if (pressed == 's')
			camera.panDown();
		else if (pressed == 'd')
			camera.panRight();
		else if (pressed == 'a') camera.panLeft();
	}

	@Override
	public void keyReleased(KeyEvent e) {
		//
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		lastMouseClick = e.getButton();
	}

	@Override
	public void mousePressed(MouseEvent e) {
		//
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		//
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		this.requestFocus();

	}

	@Override
	public void mouseExited(MouseEvent e) {
		//
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		//
	}

	@Override
	public void mouseMoved(MouseEvent e) {
		mx = e.getX();
		my = e.getY();

	}

	public void setStrategy(BufferStrategy strategy) {
		this.strategy = strategy;
	}

}
