package it.fmc.santahack2012.gfx;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;

import map.ACTOR_TYPE;
import map.Gfx;

public class GraphicsHandler {
	public static final String Santa = "Santa";
	public static final String Orc = "Orc";
	private List<BufferedImage> tileSet;
	private Map<ACTOR_TYPE, BufferedImage> buildingsMap;
	private Map<String, BufferedImage> characterMap;

	public void loadData() {
		tileSet = new ArrayList<BufferedImage>();
		buildingsMap = new HashMap<ACTOR_TYPE, BufferedImage>();
		characterMap = new HashMap<String, BufferedImage>();
		try {
			BufferedImage tiles = ImageIO.read(this.getClass().getResource("tiles.gif"));
			int tS = Gfx.TILE_SIZE;
			int ots = tS + 2; // the black border
			int wTiles = 12;
			int hTiles = 8; // tileset gif is 12x8
			for (int y = 0; y < hTiles; y++) {
				for (int x = 0; x < wTiles; x++) {
					BufferedImage bim = tiles.getSubimage(2 + x * ots, 2 + y * ots, tS, tS);
					tileSet.add(bim);
				}
			}
			BufferedImage buildings = ImageIO.read(this.getClass().getResource("buildings.gif"));
			BufferedImage bim = buildings.getSubimage(206, 0, 396 - 206, 194); // start point
			buildingsMap.put(ACTOR_TYPE.START_POINT, bim);
			bim = buildings.getSubimage(403, 0, 594 - 403, 194); // house 1
			buildingsMap.put(ACTOR_TYPE.HOUSE_1, bim);
			buildingsMap.put(ACTOR_TYPE.HOUSE_2, bim);
			buildingsMap.put(ACTOR_TYPE.HOUSE_3, bim);

			BufferedImage santa = ImageIO.read(this.getClass().getResource("santa.gif"));
			characterMap.put(Santa, santa);
			BufferedImage orc = ImageIO.read(this.getClass().getResource("orc.gif"));
			characterMap.put(Orc, orc);

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public BufferedImage getTile(int n) {
		return tileSet.get(n);
	}

	public int getTileCount() {
		return tileSet.size();
	}

	public Image getActor(ACTOR_TYPE actorType) {
		return buildingsMap.get(actorType);
	}

	public int getWidth(ACTOR_TYPE actorType) {
		return buildingsMap.get(actorType).getWidth();
	}

	public int getHeight(ACTOR_TYPE actorType) {
		return buildingsMap.get(actorType).getHeight();
	}

	public BufferedImage getCharacter(String character) {
		return characterMap.get(character);
	}
}
