package it.fmc.santahack2012.gfx;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class GfxUtils {
	public static List<BufferedImage> getMirrorX(List<BufferedImage> images) {
		List<BufferedImage> copy = new ArrayList<BufferedImage>();
		AffineTransform xform = AffineTransform.getScaleInstance(-1, 1);
		xform.translate(-images.get(0).getWidth(), 0);
		AffineTransformOp op = new AffineTransformOp(xform, AffineTransformOp.TYPE_NEAREST_NEIGHBOR);
		for (BufferedImage im : images) {
			BufferedImage image = transformedCopy(im, op);
			copy.add(image);
		}
		return copy;
	}

	private static BufferedImage transformedCopy(BufferedImage im, AffineTransformOp op) {
		int width = im.getWidth();
		int height = im.getHeight();
		int imageType = im.getType();
		BufferedImage image = new BufferedImage(width, height, imageType);
		image = op.filter(im, null);
		return image;
	}

}
