package it.fmc.santahack2012.events;

import it.fmc.santahack2012.astar.PathFinder;

import java.util.LinkedList;
import java.util.Queue;

public abstract class SimpleChar extends Selectable {
	Queue<SimpleAction> simpleDirection;
	private final float speed;
	private int currAmount;
	private SimpleAction currentAction;
	private final PathFinder pathfinder;
	private SimpleChar enemy;
	private final int unitRange;
	protected final int maxLife;
	protected int currLife;

	public SimpleChar(int x, int y, int w, int h, Animator animator, PathFinder pathfinder, int unitRange, int mLife) {
		super(x, y, w, h, animator);
		simpleDirection = new LinkedList<SimpleAction>();
		currAmount = 0;
		speed = 4;
		currentAction = null;
		this.pathfinder = pathfinder;
		this.unitRange = unitRange;
		maxLife = mLife;
		currLife = maxLife;
	}

	@Override
	public void update() {
		super.update();

		if (getState() == STATE.DYING) return;

		if (currentAction == null) newCurrentAction();

		if (getState() == STATE.ATTACKING) {
			SimpleAttack att = (SimpleAttack) currentAction;
			att.tick();
			if (att.ready()) {
				enemy.receiveHit(att.getDealtDamage());
				System.out.println(this + " hit  " + enemy + " for " + att.getDealtDamage());
				currentAction = null;
			}
		} else if (getState() == STATE.WALKING) {
			if (currentAction == null) throw new RuntimeException("current Direction shouldn't be null");
			if (!currentAction.isMovementAction())
				throw new RuntimeException("current Direction should be a movement");
			SimpleDirection curDir = (SimpleDirection) currentAction;
			DIR d = curDir.getDirection();
			if (d == DIR.N)
				y -= speed;
			else if (d == DIR.E)
				x += speed;
			else if (d == DIR.W)
				x -= speed;
			else if (d == DIR.S)
				y += speed;
			else if (d == DIR.NE) {
				x += speed;
				y -= speed;
			} else if (d == DIR.SE) {
				x += speed;
				y += speed;
			} else if (d == DIR.NW) {
				x -= speed;
				y -= speed;
			} else if (d == DIR.SW) {
				x -= speed;
				y += speed;
			}
			currAmount += speed;
			if (currAmount >= curDir.getAmount()) newCurrentAction();
		}
	}

	private boolean canReachEnemy() {
		int dx = Math.abs(x - enemy.getX());
		int dy = Math.abs(y - enemy.getY());
		if ((dx + dy) < unitRange) return true;
		return false;
	}

	public void attack(SimpleChar newEnemy) {
		enemy = newEnemy;
		currentAction = null;
		simpleDirection.clear();
	}

	private void newCurrentAction() {
		currAmount = 0;
		if (enemy != null) {// if we have an enemy
			if (enemy.getState() == STATE.DYING) {
				enemy = null;
				newCurrentAction();
			} else if (canReachEnemy()) {
				DIR facing = faceEnemyDirection(enemy.getX(), enemy.getY());
				this.setState(STATE.ATTACKING, facing);
				simpleDirection.clear();
				currentAction = getAttackType();
			} else {
				simpleDirection = pathfinder.getDirectionsToPoint(getX() + getW() / 2, getY() + getH() / 2,
						enemy.getX(), enemy.getY());
				if (simpleDirection.isEmpty()) {
					this.setState(STATE.IDLE);
					enemy = null;
				} else {
					currentAction = simpleDirection.poll();
					setState(STATE.WALKING, ((SimpleDirection) currentAction).getDirection());
				}
			}

		} else {
			if (simpleDirection.isEmpty()) {
				currentAction = null;
				this.setState(STATE.IDLE);
			} else {
				currentAction = simpleDirection.poll();
				if (currentAction != null) {
					setState(STATE.WALKING, ((SimpleDirection) currentAction).getDirection());
				}
			}
		}
	}

	protected abstract SimpleAction getAttackType();

	private DIR faceEnemyDirection(int fx, int fy) {
		// DIR dirs[] = { DIR.NW, DIR.N, DIR.NE, DIR.E, DIR.SE, DIR.S, DIR.SW, DIR.W };
		// double res = Math.atan2(dy, dx) + Math.PI; // 0-2PI
		// int n = (int) Math.floor(res / Math.PI * 4);
		// n = Math.max(dirs.length - 1, n);
		// return dirs[n];
		DIR dir = DIR.N;
		int dx = fx / 64 - x / 64;
		int dy = fy / 64 - y / 64;
		if (dx > 0) {
			if (dy == 0) dir = DIR.E;
			if (dy > 0)
				dir = DIR.SE;
			else
				dir = DIR.NE;
		} else if (dx < 0) {
			if (dy == 0) dir = DIR.W;
			if (dy > 0)
				dir = DIR.SW;
			else
				dir = DIR.NW;
		} else {
			if (dy > 0)
				dir = DIR.S;
			else
				dir = DIR.N;
		}
		return dir;
	}

	@Override
	public void moveAtLocation(int mx, int my) {
		enemy = null;
		currentAction = null;
		simpleDirection = pathfinder.getDirectionsToPoint(getX() + getW() / 2, getY() + getH() / 2, mx, my);
		this.setState(STATE.WALKING);
	}

	public void receiveHit(int amount) {
		currLife -= amount;
		if (currLife <= 0) {
			this.setState(STATE.DYING, DIR.NONE);
			currLife = 0;
		}
		System.out.println(this + " hit for " + amount);
	}

	public int getCurrLife() {
		return currLife;
	}

	public void setCurrLife(int currLife) {
		this.currLife = currLife;
	}

	public int getMaxLife() {
		return maxLife;
	}

	@Override
	public boolean isSimpleChar() {
		return true;
	}

	public boolean isAlive() {
		return getState() != STATE.DYING;
	}
}
