package it.fmc.santahack2012.events;

import it.fmc.santahack2012.gfx.GfxUtils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SantaAnimator implements Animator {
	private final int w;
	private final int h;
	private final BufferedImage image;
	private Map<CharState, List<BufferedImage>> state2Image;
	private CharState charState;
	private final int maxStep;
	private int step;

	public SantaAnimator(BufferedImage im) {
		w = 89;
		h = 113;
		image = im;
		charState = new CharState();
		buildState2ImageMap();
		step = 0;
		maxStep = 18;
	}

	private void buildState2ImageMap() {
		state2Image = new HashMap<CharState, List<BufferedImage>>();
		int STARTX = 33;
		DIR ordered[] = { DIR.N, DIR.NE, DIR.E, DIR.SE, DIR.S };
		DIR toFlip[][] = { { DIR.NE, DIR.NW }, { DIR.E, DIR.W }, { DIR.SE, DIR.SW } };
		// WALKING
		for (int x = 0; x < 5; x++) {
			List<BufferedImage> setImages = new ArrayList<BufferedImage>();
			for (int y = 0; y < 5; y++) {
				int x1 = STARTX + x * 148;
				int y1 = 7 + y * 120;
				BufferedImage im = image.getSubimage(x1, y1, w, h);
				setImages.add(im);
			}
			state2Image.put(new CharState(STATE.WALKING, ordered[x]), setImages);
		}
		for (DIR[] dir : toFlip) {
			List<BufferedImage> set = GfxUtils.getMirrorX(state2Image.get(new CharState(STATE.WALKING, dir[0])));
			state2Image.put(new CharState(STATE.WALKING, dir[1]), set);
		}
		// IDLE
		int y1 = 10;
		List<BufferedImage> setImages = new ArrayList<BufferedImage>();
		for (int x = 0; x < 5; x++) {
			int x1 = STARTX + x * 148;
			BufferedImage im = image.getSubimage(x1, y1, w, h);
			setImages.add(im);
		}
		state2Image.put(new CharState(STATE.IDLE, DIR.N), setImages.subList(0, 1));
		state2Image.put(new CharState(STATE.IDLE, DIR.NE), setImages.subList(1, 2));
		state2Image.put(new CharState(STATE.IDLE, DIR.E), setImages.subList(2, 3));
		state2Image.put(new CharState(STATE.IDLE, DIR.SE), setImages.subList(3, 4));
		state2Image.put(new CharState(STATE.IDLE, DIR.S), setImages.subList(4, 5));

		state2Image.put(new CharState(STATE.IDLE, DIR.NW), GfxUtils.getMirrorX(setImages.subList(1, 2)));
		state2Image.put(new CharState(STATE.IDLE, DIR.W), GfxUtils.getMirrorX(setImages.subList(2, 3)));
		state2Image.put(new CharState(STATE.IDLE, DIR.SW), GfxUtils.getMirrorX(setImages.subList(3, 4)));
		// Attacking
		for (int x = 0; x < 5; x++) {
			setImages = new ArrayList<BufferedImage>();
			for (int y = 0; y < 4; y++) {
				int x1 = 34 + x * 148;
				y1 = 615 + y * 120;
				BufferedImage im = image.getSubimage(x1, y1, w, h);
				setImages.add(im);
			}
			state2Image.put(new CharState(STATE.ATTACKING, ordered[x]), setImages);
		}
		for (DIR[] dir : toFlip) {
			List<BufferedImage> set = GfxUtils.getMirrorX(state2Image.get(new CharState(STATE.ATTACKING, dir[0])));
			state2Image.put(new CharState(STATE.ATTACKING, dir[1]), set);
		}
		// DEATH
		y1 = 1110;
		setImages = new ArrayList<BufferedImage>();
		for (int x = 0; x < 5; x++) {
			int x1 = 22 + x * 148;
			BufferedImage im = image.getSubimage(x1, y1, w, h);
			setImages.add(im);
		}
		state2Image.put(new CharState(STATE.DYING, DIR.NONE), setImages);
	}

	@Override
	public void update() {
		step++;
		if (step > maxStep) step = 0;
	}

	@Override
	public void setState(STATE state, DIR d) {
		charState = new CharState(state, d);
	}

	@Override
	public Image getImage() {
		List<BufferedImage> set = state2Image.get(charState);
		int imgs = set.size() - 1;
		int pos = (int) Math.ceil((((float) step / maxStep) * imgs));
		return set.get(pos);
	}

	public int getW() {
		return w;
	}

	public int getH() {
		return h;
	}
}
