package it.fmc.santahack2012.events;

import it.fmc.santahack2012.astar.PathFinder;
import map.Gfx;

public class Santa extends AllyChar {

	private static final int SANTA_LIFE = 200;
	private static final int SANTA_DAMAGE = 10;

	public Santa(int x, int y, SantaAnimator animator, PathFinder pathfinder) {
		super(x, y, animator.getW(), animator.getH(), animator, pathfinder, Gfx.TILE_SIZE * 5, SANTA_LIFE);
	}

	@Override
	public void update() {
		super.update();
	}

	@Override
	public String toString() {
		return "Santa";
	}

	@Override
	protected SimpleAction getAttackType() {
		return new SimpleAttack(SANTA_DAMAGE);
	}

	public void heal() {
		currLife = maxLife;
	}
}
