package it.fmc.santahack2012.events;

import it.fmc.santahack2012.astar.PathFinder;
import map.Gfx;

public class Orc extends EnemyChar {

	private static final int ORC_LIFE = 50;
	private static final int ORC_DAMAGE = 7;

	public Orc(int x, int y, OrcAnimator animator, PathFinder pathfinder) {
		super(x, y, animator.getW(), animator.getH(), animator, pathfinder, Gfx.TILE_SIZE * 3, ORC_LIFE);
	}

	@Override
	public boolean isSelectable() {
		return false;
	}

	@Override
	public String toString() {
		return "Orc";
	}

	@Override
	protected SimpleAction getAttackType() {
		return new SimpleAttack(ORC_DAMAGE);
	}
}
