package it.fmc.santahack2012.events;

import java.awt.Image;

public abstract class Interactable implements Updatable {
	protected int x;
	protected int y;
	private final int w;
	private final int h;
	private STATE state;
	private final Animator animator;
	private DIR dir;

	public Interactable(int x, int y, int w, int h, Animator animator) {
		super();
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		state = STATE.IDLE;
		dir = DIR.N;
		this.animator = animator;
		this.animator.setState(state, dir);
	}

	public abstract boolean isSelectable();

	public abstract boolean isAttackableByAlly();

	public abstract boolean isAttackableByEnemy();

	public abstract InteractableType getType();

	@Override
	public void update() {
		animator.update();
	}

	public void setState(STATE state, DIR d) {
		this.state = state;
		dir = d;
		animator.setState(this.state, d);
	}

	public void setState(STATE state) {
		this.state = state;
		animator.setState(this.state, dir);
	}

	public ScreenRect getBounds() {
		return new ScreenRect(x, y, x + w, y + h);
	}

	public boolean isMouseOn(int mx, int my) {
		boolean res = false;
		if (mx > x && mx < (x + w) && my > y && my < (y + h)) res = true;
		return res;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getW() {
		return w;
	}

	public int getH() {
		return h;
	}

	public STATE getState() {
		return state;
	}

	public Animator getAnimator() {
		return animator;
	}

	public Image getImage() {
		return animator.getImage();
	}

	public void face(DIR d) {
		dir = d;
		updateAnimator();
	}

	private void updateAnimator() {
		animator.setState(state, dir);
	}

	@Override
	public abstract String toString();

	public abstract boolean isSimpleChar();

}
