package it.fmc.santahack2012.events;

import java.util.List;

import map.GameMap;
import map.Gfx;

public class FogOfWar {

	private final boolean[][] grid;
	private final int viewSize;
	private final int maxX;
	private final int maxY;
	private final int tSize;

	public FogOfWar(GameMap gmap) {
		final int w = gmap.getTilesX();
		final int h = gmap.getTilesY();
		grid = new boolean[h][w];
		for (int y = 0; y < h; y++)
			for (int x = 0; x < w; x++)
				grid[y][x] = true;

		viewSize = 4;
		maxX = grid[0].length;
		maxY = grid.length;
		tSize = Gfx.TILE_SIZE;
	}

	public boolean[][] getFogGrid() {
		return grid;
	}

	public void update(List<Interactable> interactables) {
		for (Interactable i : interactables) {
			if (i.getType() == InteractableType.ALLY) {
				final int iX = i.getX() / tSize;
				final int iY = (i.getY() + i.getH() / 2) / tSize;
				final int sX = Math.max(0, iX - viewSize);
				final int sY = Math.max(0, iY / tSize - viewSize);
				final int eX = Math.min(maxX, iX + viewSize + 1);
				final int eY = Math.min(maxY, iY + viewSize + 1);
				for (int y = sY; y < eY; y++)
					for (int x = sX; x < eX; x++) {
						int distX = Math.abs(iX - x);
						int distY = Math.abs(iY - y);
						if ((distX + distY) > (viewSize + 1)) continue;
						grid[y][x] = false;
					}
			}
		}

	}
}
