package it.fmc.santahack2012.events;

import it.fmc.santahack2012.astar.PathFinder;
import it.fmc.santahack2012.gfx.GraphicsHandler;

import java.awt.image.BufferedImage;

public class CharacterFactory {
	private final GraphicsHandler graphicsHandler;
	private final PathFinder pathFinder;

	public CharacterFactory(GraphicsHandler gh, PathFinder pathf) {
		graphicsHandler = gh;
		pathFinder = pathf;
	}

	public Santa getSanta(int x, int y) {
		Santa santa = null;
		BufferedImage im = graphicsHandler.getCharacter(GraphicsHandler.Santa);
		santa = new Santa(x, y, new SantaAnimator(im), pathFinder);
		return santa;
	}

	public Orc getOrc(int x, int y) {
		Orc orc = null;
		BufferedImage im = graphicsHandler.getCharacter(GraphicsHandler.Orc);
		orc = new Orc(x, y, new OrcAnimator(im), pathFinder);
		return orc;
	}
}
