package it.fmc.santahack2012.events;

public class CharState {
	private final STATE state;
	private final DIR dir;

	public CharState(STATE state, DIR dir) {
		this.state = state;
		this.dir = dir;
	}

	public CharState() {
		this(STATE.IDLE, DIR.N);
	}

	public STATE getState() {
		return this.state;
	}

	public DIR getDir() {
		return this.dir;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.dir == null) ? 0 : this.dir.hashCode());
		result = prime * result + ((this.state == null) ? 0 : this.state.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (this.getClass() != obj.getClass()) return false;
		CharState other = (CharState) obj;
		if (this.dir != other.dir) return false;
		if (this.state != other.state) return false;
		return true;
	}
}
