package it.fmc.santahack2012.events;

import map.ACTOR_TYPE;

public class AllyBuilding extends Selectable {
	private boolean isAttackable = false;
	private boolean isStartPoint = false;
	private int houseType;

	public AllyBuilding(int x, int y, int w, int h, Animator animator, ACTOR_TYPE type) {
		super(x, y, w, h, animator);
		isAttackable = false;
		isStartPoint = false;
		if (type == ACTOR_TYPE.START_POINT) {
			isAttackable = true;
			isStartPoint = true;
			houseType = 0;
		} else if (type == ACTOR_TYPE.HOUSE_1)
			houseType = 1;
		else if (type == ACTOR_TYPE.HOUSE_2)
			houseType = 2;
		else if (type == ACTOR_TYPE.HOUSE_3) houseType = 3;

	}

	@Override
	public boolean isSelectable() {
		return true;
	}

	@Override
	public boolean isAttackableByAlly() {
		return false;
	}

	@Override
	public boolean isAttackableByEnemy() {
		return isAttackable;
	}

	@Override
	public InteractableType getType() {
		return InteractableType.ALLY_BUILDING;
	}

	public boolean isStartPoint() {
		return isStartPoint;
	}

	@Override
	public String toString() {
		return "Ally building";
	}

	@Override
	public void moveAtLocation(int mx, int my) {
		return;
	}

	@Override
	public boolean isSimpleChar() {
		return false;
	}

	public int activate() {
		return houseType;
	}

}
