package it.fmc.santahack2012.astar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;

public class Test extends JFrame implements MouseListener {
	private static final long serialVersionUID = 1407441868164480233L;
	private final int h;
	private final int w;
	private final int[][] grid;
	private Position solution;
	private final static int tSize = 32;

	public Test() {
		h = 24;
		w = 24;
		grid = new int[h][w];
		for (int y = 0; y < h; y++)
			for (int x = 0; x < w; x++) {
				int val = 0;
				if (x == 4 && y > 1 && y < 9) val = 1;
				if (x == 4 && y > 1 && y < 8) val = 1;
				grid[y][x] = val;
			}

		this.setSize(new Dimension((w + 0) * tSize, (h + 0) * tSize));
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setVisible(true);
		addMouseListener(this);
		solution = null;
	}

	@Override
	public void paint(Graphics g) {
		g.clearRect(0, 0, w * tSize, h * tSize);
		for (int y = 0; y < h; y++) {
			for (int x = 0; x < w; x++) {
				if (grid[y][x] == 1)
					g.setColor(Color.darkGray);
				else if (grid[y][x] == 2)
					g.setColor(Color.green);
				else if (grid[y][x] == 3)
					g.setColor(Color.red);
				else
					g.setColor(Color.white);
				g.fillRect(x * tSize, y * tSize, tSize, tSize);
				g.setColor(Color.black);
				g.drawRect(x * tSize, y * tSize, tSize, tSize);
			}
		}

		if (solution != null) {
			Position current = solution.getParent();
			while (current != null) {
				int x = current.getX();
				int y = current.getY();
				g.setColor(Color.magenta);
				g.fillOval((int) ((x + 0.25) * tSize), (int) ((y + 0.25) * tSize), tSize / 2, tSize / 2);
				current = current.getParent();
			}
		}
		g.dispose();
	}

	public static void main(String[] args) {
		new Test();
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.getButton() == MouseEvent.BUTTON1) {
			int x = e.getX() / tSize;
			int y = e.getY() / tSize;

			grid[y][x]++;
			if (grid[y][x] > 3) grid[y][x] = 0;
		} else if (e.getButton() == MouseEvent.BUTTON3) astar();

		this.repaint();
	}

	@Override
	public void mousePressed(MouseEvent e) {
		//
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		//
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		//
	}

	@Override
	public void mouseExited(MouseEvent e) {
		//
	}

	public void astar() {
		int sX = 0, sY = 0, eX = 1, eY = 1;
		for (int y = 0; y < h; y++)
			for (int x = 0; x < w; x++) {
				if (grid[y][x] == 2) {
					sX = x;
					sY = y;
				}
				if (grid[y][x] == 3) {
					eX = x;
					eY = y;
				}
			}
		Position start = new Position(sX, sY, 0, 0, null);
		List<Position> openList = new ArrayList<Position>();
		List<Position> closedList = new ArrayList<Position>();
		openList.add(start);// start point

		solution = null;
		int iterations = 0;
		while (!openList.isEmpty()) {
			Position current = getLowestF(openList);
			if (current.getX() == eX && current.getY() == eY) {
				solution = current;
				break;
			}
			openList.remove(current);
			closedList.add(current);
			addNeighbours(current, grid, eX, eY, closedList, openList);
			iterations++;
			System.out.println("Iteration " + iterations);
		}
		System.out.println("Found");
	}

	private Position getLowestF(List<Position> openList) {
		if (openList.isEmpty()) return null;
		Position l = openList.get(0);
		for (Position p : openList) {
			if (l.getF() > p.getF()) l = p;
		}
		return l;
	}

	private void addNeighbours(Position parent, int[][] mapGrid, int eX, int eY, List<Position> closedList,
			List<Position> openList) {
		int Y = parent.getY();
		int X = parent.getX();
		for (int y = Y - 1; y <= Y + 1; y++)
			for (int x = X - 1; x <= X + 1; x++) {
				if (x >= 0 && x < w && y >= 0 && y < h) {
					if (x == X && y == Y) continue; // parent square
					if (mapGrid[y][x] == 1) continue; // blocking
					// set G
					int G = 10;
					if (y != Y && x != X) G = 14;
					G = G + parent.getG();
					// set H
					int H = (Math.abs(eX - x) + Math.abs(eY - y)) * 10;
					Position p = new Position(x, y, H, G, parent);
					if (!closedList.contains(p)) {
						int index = openList.indexOf(p);
						if (index == -1)
							openList.add(p);
						else {
							Position old = openList.get(index);
							if (old.getG() > p.getG()) {// this parent is better
								old.setParent(parent);
								old.recalculate();
							}
						}
					}
				}
			}
	}
}
