package it.fmc.santahack2012.astar;

public class Position {
	private final int x, y;
	private int F, G;
	private final int H;
	private Position parent;

	public Position(int x, int y, int H, int G, Position parent) {
		this.x = x;
		this.y = y;
		this.parent = parent;
		this.H = H;
		this.G = G;
		this.F = G + H;
	}

	public int getX() {
		return this.x;
	}

	public int getY() {
		return this.y;
	}

	public Position getParent() {
		return this.parent;
	}

	public void setParent(Position parent) {
		this.parent = parent;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + this.x;
		result = prime * result + this.y;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (this.getClass() != obj.getClass()) return false;
		Position other = (Position) obj;
		if (this.x != other.x) return false;
		if (this.y != other.y) return false;
		return true;
	}

	public int getF() {
		return this.F;
	}

	public void setF(int f) {
		this.F = f;
	}

	public int getG() {
		return this.G;
	}

	public void setG(int g) {
		this.G = g;
	}

	public void recalculate() {
		this.G = this.parent.getG();
		int cost = 10;
		if (this.parent.getX() != this.x && this.parent.getY() != this.y) cost = 14;

		this.G += cost;

		this.F = this.G + this.H;
	}
}
