/*
* Donald Adu-Poku
* 5/22/12 2:28 PM
* engine.c
*/

#include <iso646.h>
#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "display.h"
#include "core.h"
#include "helper_funcs.h"

static void init() { assert(al_init()); }

static void run_once()
{
	Core * core =  alloc();
	init_core(core);
	if(not core) { perror_with_context("Failed to create Core", __LINE__, __FILE__); exit(EXIT_FAILURE); }
	else 
	{
		run_core(core);
		shutdown_core(core);
	}
}

static void shutdown() { al_uninstall_system(); }

int main (int argc, char **argv)
{
	init();
	run_once();
	shutdown();
	return 0;
}

