/*
* Donald Adu-Poku
* 5/22/12 1:00 PM
* display.c
*/

#include <iso646.h>
#include <stdbool.h>
#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "allegro5/allegro_font.h"
#include "allegro5/allegro_ttf.h"
#include "alias.h"
#include "display.h"
#include "helper_funcs.h"

	Display * init_display(ALLEGRO_EVENT_QUEUE * queue, const Size size)
	{
		Display * display = (Display *) malloc(sizeof(Display));
		
		switch(size)
		{
			case W800_H600: {display->width = 800; display->height = 600;} break;
			case W1280_H800: {display->width = 1280; display->height = 800;} break;
			case W960_H540: {display->width = 960; display->height = 540;} break;
			default: {display->width = 0; display->height = 0;}
		}
	
		if((display->width > 0) and (display->height > 0))
		{ 
			display->backbuffer = al_create_display(display->width, display->height);
			al_register_event_source(queue, al_get_display_event_source(display->backbuffer));
			if(not display->backbuffer) { perror_with_context("Failed to create ALLEGRO_DISPLAY", __LINE__, __FILE__); exit(EXIT_FAILURE); }
			else {
				al_set_target_backbuffer(display->backbuffer);
				if(not al_init_image_addon()) { perror_with_context("al_init_image_addon failed", __LINE__, __FILE__); exit(EXIT_FAILURE); }
			}
		}
		return display;
	}
	
	void blit() { al_flip_display();} 
	
	void destroy_display(Display * display) { al_destroy_display(display->backbuffer); free(display); }
