/*
* Donald Adu-Poku
* 5/22/12 5:31 PM
* core.c
*/

#include <math.h>
#include <iso646.h>
#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "jansson.h"
#include "background.h"
#include "display.h"
#include "core.h"
#include "helper_funcs.h"

	bool end_run = false;
	
	Core * alloc() { Core * core  = (Core *) malloc(sizeof(Core)); return core; }
	
	void init_core(Core * core)
	{
		core->queue = init_event_queue(core->queue);
		core->display = init_display(core->queue, W960_H540);
		core->timer = init_timer(core->queue);
		core->input = init_input(core->queue);
		/* init_font(); */
		/* init audio */
		/* init physics */
	}
	
	ALLEGRO_EVENT_QUEUE * init_event_queue()
	{
		
		ALLEGRO_EVENT_QUEUE * queue = al_create_event_queue(); 
		if(not queue) { perror_with_context("Failed to create ALLEGRO_EVENT_QUEUE", __LINE__, __FILE__); exit(EXIT_FAILURE); }
		return queue;
	}
	
	ALLEGRO_TIMER * init_timer(ALLEGRO_EVENT_QUEUE * queue)
	{
		ALLEGRO_TIMER * timer = al_create_timer(ALLEGRO_BPS_TO_SECS(FPS));
		if(not timer) { perror_with_context("Failed to create ALLEGRO_TIMER", __LINE__, __FILE__); exit(EXIT_FAILURE); }
		else { al_register_event_source(queue, al_get_timer_event_source(timer)); }
		return timer;
	}
	
	ALLEGRO_EVENT_SOURCE * init_input(ALLEGRO_EVENT_QUEUE * queue)
	{
		ALLEGRO_EVENT_SOURCE * input;
		if(not al_install_keyboard()) { perror_with_context("al_install_keyboard failed", __LINE__, __FILE__); exit(EXIT_FAILURE); }
		else
		{
			input = al_get_keyboard_event_source();
			if(not input) { perror_with_context("Failed to create ALLEGRO_EVENT_SOURCE", __LINE__, __FILE__); exit(EXIT_FAILURE);}
			else { al_register_event_source(queue, input); }
		}
		return input;
	}
	
	/*void init_font() 
	{
		al_init_font_addon(); 
  		if(not al_init_ttf_addon()) { perror_with_context("al_init_ttf_addon failed", __LINE__, __FILE__); exit(EXIT_FAILURE); }
	} */
	
	void run_core(Core * core)
	{
 		al_start_timer(core->timer);
 		Background * background = init_background("../frames/frames.json");
		while(not end_run)
		{
			ALLEGRO_EVENT event;
			al_wait_for_event(core->queue, &event);
			
			if(event.type == ALLEGRO_EVENT_TIMER) 
			{
				/* update physics */
				draw_background(background->frame);
				frame_step(background);
				blit();
			}
			else if(event.type == ALLEGRO_EVENT_DISPLAY_CLOSE)  { end_run = true; }
			else if(event.type == ALLEGRO_EVENT_KEY_DOWN)
			{
				ALLEGRO_KEYBOARD_STATE state;
				al_get_keyboard_state(&state);
				/* get input update */
			}
		}
		destroy_background(background);
}

	void shutdown_core(Core * core)
	{
		if(not core)
		{
			al_unregister_event_source(core->queue, core->input);
			al_destroy_timer(core->timer);
			al_destroy_event_queue(core->queue);
			al_uninstall_keyboard();
			destroy_display(core->display);
			free(core);
		}
	}
	