/*
* Donald Adu-Poku
* 5/24/12 11:48 PM
* background.c
*/

#include <iso646.h>
#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "jansson.h"
#include "alias.h"
#include "background.h"
#include "helper_funcs.h"

	Background * init_background(const char * json_filepath)
	{
		json_t * root;
		json_error_t * error;
		Background * background;
		background  = (Background *) malloc(sizeof(Background));
		background->frame_paths = (char **) malloc(sizeof(char *) * 5852);
		
		root = json_load_file(json_filepath, 0, error);
		if(not root) { perror_with_context("Loading JSON file failed", __LINE__, __FILE__);  exit(EXIT_FAILURE); }
		else { parse_background(root, background); }
		
		return background;
	}
	
	void parse_background(json_t * root, Background * background)
	{
		if(not json_is_array(root)) { perror_with_context("root is not an array", __LINE__, __FILE__); exit(EXIT_FAILURE); }
		else
		{
			for(size_t idx = 0; idx < json_array_size(root); ++idx)
			{
				json_t * frame_filepath = json_array_get(root, idx);
				char * filepath = (char *) json_string_value(frame_filepath);
				if(not filepath) { perror_with_context("File path is not a string", __LINE__, __FILE__); exit(EXIT_FAILURE); }
				else 
				{ 
					background->frame_paths[idx] = (char *) malloc(sizeof(char) * strlen(filepath)); 
					strcpy(background->frame_paths[idx], filepath);
				}
			}
			background->current_frame_path = *background->frame_paths;
			background->last_frame_path = *background->frame_paths + 5852;
			json_decref(root);
		}
	}
	
	void frame_step(Background * background) 
	{ 
		if(background->frame == NULL) { background->frame =  al_load_bitmap(background->current_frame_path); }
		else
		{ 
			al_destroy_bitmap(background->frame); 
			background->frame =  al_load_bitmap(background->current_frame_path);
		}
		if(not background->frame) { perror_with_context("Frame failed to load", __LINE__, __FILE__); exit(EXIT_FAILURE); }
		if(background->current_frame_path < background->last_frame_path) 
		{ background->current_frame_path = ++background->current_frame_path; }
	}
	
	void draw_background(ALLEGRO_BITMAP * frame) { al_draw_bitmap(frame, 0, 0, 0); }
	
	void destroy_background(Background *background)
	{
		if(not background->frame) { al_destroy_bitmap(background->frame); }
		free(background->frame_paths);
		free(background);
	}