#version 150

uniform mat4 terrain_Projection;
uniform mat4 terrain_View;

uniform float terrain_Height;
uniform vec2 terrain_Size;

uniform sampler2D terrain_Heightmap;

in vec2 terrain_Position;

smooth out vec2 frag_Position;

void main()
{
	float h = texture(terrain_Heightmap, terrain_Position / terrain_Size).x * terrain_Height;
	gl_Position = terrain_Projection * terrain_View * vec4(terrain_Position.x, h, terrain_Position.y, 1.0);
	
	frag_Position = terrain_Position / terrain_Size;
}
