#version 150

uniform float terrain_Height;
uniform vec2 terrain_Size;

uniform sampler2D terrain_Heightmap;

smooth in vec2 frag_Position;

out vec4 terrain_Color;

vec3 CalculateNormal()
{
	vec2 position = frag_Position;
	
	float s1 = textureOffset(terrain_Heightmap, position, ivec2(-1, 0)).x;
	float s2 = textureOffset(terrain_Heightmap, position, ivec2(1, 0)).x;
	float s3 = textureOffset(terrain_Heightmap, position, ivec2(0, -1)).x;
	float s4 = textureOffset(terrain_Heightmap, position, ivec2(0, 1)).x;
	vec3 v1 = normalize(vec3(1.0, (s2 - s1) * terrain_Height, 0.0));
	vec3 v2 = normalize(vec3(0.0, (s4 - s3) * terrain_Height, -1.0));
	
	return normalize(cross(v1, v2));
}

void main()
{
	terrain_Color = vec4(CalculateNormal().rgb, 1.0);
}
