#include <allegro5/allegro.h>
#include <allegro5/allegro_opengl.h>
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_color.h>
#include <allegro5/allegro_image.h>
#include "sh11_common.h"



// Default Allegro globals
ALLEGRO_EVENT_QUEUE *timer_events = NULL;
ALLEGRO_EVENT_QUEUE *key_events = NULL;
ALLEGRO_DISPLAY *display = NULL;
ALLEGRO_TIMER *timer = NULL;
ALLEGRO_FONT *font = NULL;
ALLEGRO_EVENT event;

int display_width, display_height;
int display_flags = 0;
int bitmap_flags = 0;



int game_mode = 0;
int game_over = 0;
int mode_count = 0;				// Counts the number of frames in the current game mode
int timer_count = 0;


// Misc. globals
int frame_count = 0,
    pframe_count = 0,
    fps = 0;



void init() {
	int w, h, fs, ogl, no_preserve_texture;
	ALLEGRO_MONITOR_INFO info;
	ALLEGRO_CONFIG *c = NULL;
	int video_adapter;

	if (!al_init())
		error_message("\nCould not init Allegro", C_ALLEGRO_ERROR);
	if (!al_install_mouse())
		error_message("\nCould not install mouse driver", C_ALLEGRO_ERROR);
	if (!al_install_keyboard())
		error_message("\nCould not install keyboard driver", C_ALLEGRO_ERROR);
	if (!al_init_image_addon())
		error_message("\nCould not init Image addon", C_ALLEGRO_ERROR);
	al_init_font_addon();
	font = al_load_font("fixed_font.tga", 120, 0);
	if (!font)
		error_message("\nFailed to load fixed_font.tga", C_ALLEGRO_ERROR);
	
	c = al_load_config_file("sh11_game.cfg");
	if (!c) {
		puts("\nFailed to load configuration file");
        puts("\nLoading default values...");
		w = 800; h = 600; fs = 0; ogl = 0; no_preserve_texture = 0;
	}
    else {
        w = atoi(al_get_config_value(c, NULL, "WIDTH"));
        h = atoi(al_get_config_value(c, NULL, "HEIGHT"));
        fs = atoi(al_get_config_value(c, NULL, "FULLSCREEN"));
        ogl = atoi(al_get_config_value(c, NULL, "USE_OPENGL"));
        if (ogl) no_preserve_texture = atoi(al_get_config_value(c, "OPENGL", "ALLEGRO_NO_PRESERVE_TEXTURE"));
        else no_preserve_texture = atoi(al_get_config_value(c, "DIRECT3D", "ALLEGRO_NO_PRESERVE_TEXTURE"));
    }
    al_destroy_config(c);
    
    key_events = al_create_event_queue();
	if (!key_events)
        error_message("\nFailed to create keyboard event queue", C_ALLEGRO_ERROR);
	al_register_event_source(key_events, al_get_keyboard_event_source());
    
    timer = al_create_timer(ALLEGRO_BPS_TO_SECS(30));
    if (!timer)
        error_message("\nCould not install timer", C_ALLEGRO_ERROR);
    al_start_timer(timer);
    timer_events = al_create_event_queue();
    if (!timer_events)
        error_message("\nFailed to create timer event queue", C_ALLEGRO_ERROR);
	al_register_event_source(timer_events, al_get_timer_event_source(timer));
	
	if (no_preserve_texture) bitmap_flags |= ALLEGRO_NO_PRESERVE_TEXTURE;
	
	if (fs) display_flags |= ALLEGRO_FULLSCREEN_WINDOW;
	else display_flags |= ALLEGRO_WINDOWED;
	if (ogl) display_flags |= ALLEGRO_OPENGL;
	else display_flags |= ALLEGRO_DIRECT3D;
	
	//al_get_num_video_adapters();
	al_set_new_display_adapter(0);
	video_adapter = al_get_new_display_adapter();
	al_get_monitor_info(video_adapter, &info);
	
	al_set_new_display_flags(display_flags);
    //al_set_new_window_position(0, 0);
	if (fs) display = al_create_display(info.x2 - info.x1, info.y2 - info.y1);
	else display = al_create_display(w, h);
	if (!display)
		error_message("\nFailed to create display", 1);
	display_width = al_get_display_width(display);
	display_height = al_get_display_height(display);
	al_set_window_title(display, "SpeedHack 2011");
}



int main() {
	init();
    
    while (!game_over) {
		timer_count = al_get_timer_count(timer);
		while (timer_count > 0) {
			mode_count++;
        // Cheap FPS calculator
            if (mode_count % 30 == 0) {
                fps = frame_count - pframe_count;
                pframe_count = frame_count;
            }
        // Logic goes here
			if (!al_is_event_queue_empty(key_events)) {
                al_get_next_event(key_events, &event);
                if (event.type == ALLEGRO_EVENT_KEY_UP && event.keyboard.keycode == ALLEGRO_KEY_ESCAPE)
                    game_over = TRUE;
                if (event.type == ALLEGRO_EVENT_KEY_UP && event.keyboard.keycode == ALLEGRO_KEY_SPACE)
                    al_rest(2);
            }
			timer_count--;
            al_add_timer_count(timer, -1);
		}
    // Drawing goes here
		al_clear_to_color(al_map_rgb(0, 128, 128));
        al_draw_textf(font, al_map_rgb(255, 255, 255), 0, 0, 0, "%d total frames (%d FPS)", frame_count, fps);
		al_flip_display();
    // If the timer event queue is empty, take a rest
		al_wait_for_event(timer_events, NULL);
        al_flush_event_queue(timer_events);
		
		frame_count++;
	}
	
	al_stop_timer(timer);
	al_destroy_display(display);
	return 0;
}
