//Allegro 5 
#include <allegro5/allegro.h>
#include <allegro5/allegro5.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_opengl.h>

#include <allegro5/allegro_native_dialog.h>
#include <stdlib.h>
#include <vector> 
#include <string>
#include <ctime>
#include <iostream>
#include <fstream>
#include "SKALE/Skeleton.hpp"
#include "SKALE/IKSolver.hpp"
#include <math.h>

ALLEGRO_BITMAP *backbuffer = NULL;
GLhandleARB tinter;
GLhandleARB tinter_shader;

skl::IKSolver solver;

 float r = 0.5, g = 0.5, b = 1, ratio = 0;
 int dir = 1;

 std::ifstream myFile = std::ifstream("shader.txt",std::ios::in);

 double start;
 GLint loc;

#define FRAME_RATE 60

//Globals
ALLEGRO_DISPLAY *display = NULL;
ALLEGRO_TIMER *timer = NULL;
ALLEGRO_EVENT event;
ALLEGRO_EVENT_QUEUE *queue = NULL;
ALLEGRO_BITMAP *rope;
bool done = false;
skl::Skeleton skeleton;

std::string shader;

const char* shade[1];

void loadShader()
{
	// Open the file
	std::ifstream File("shader.txt", std::ios::in);
	if (!File.is_open()) { }// Get the size of the file
	File.seekg(0, std::ios::end);int Size = File.tellg();
	File.seekg(0, std::ios::beg);
	File.clear();// Read in the shader source code
	char *Source = new char[Size + 1];memset(Source, 0, Size);
	File.read(Source, Size);
	File.close();
	Source[Size] = '\0';

	shade[0] = Source;

}
void resizeBackBufferToDisplay()
{
	if(backbuffer)
	{
		al_destroy_bitmap(backbuffer);
		backbuffer = NULL;
	}

	backbuffer = al_create_bitmap(al_get_display_width(al_get_current_display()),
		al_get_display_height(al_get_current_display()));
}
void initializeAllegro() {
	//Initialize Allegro
	if(!al_init())
	{
		throw std::exception("Allegro failed to initialize");
	}

	if(!al_init_image_addon())
	{
		throw std::exception("Allegro image addon failed to initialize");
	}
	al_init_font_addon();

	if(!al_init_ttf_addon())
	{
		throw std::exception("Allegro ttf addon failed to initialize");
	}

	if(!al_init_primitives_addon())
	{
		throw std::exception("Allegro primitives addon failed to initialize");
	}
	if(!al_install_mouse())
	{
		throw std::exception("Allegro mouse failed to initialize");
	}
	if(!al_install_keyboard())
	{
		throw std::exception("Allegro keyboard failed to initialize");
	}
	
	// Start a timer to regulate speed
	timer = al_create_timer(1.0/FRAME_RATE);
	al_start_timer(timer);

	//show screen

	al_set_new_display_flags(ALLEGRO_RESIZABLE | ALLEGRO_OPENGL);

	display = al_create_display(640,480);

	if(!display)
	{
		done = true;
	}
	//show the mouse
	al_show_mouse_cursor(display); 



	//Window Title
	al_set_window_title(display,"SKALE - Example");

	queue = al_create_event_queue();

	rope = al_load_bitmap("rope.png");
	resizeBackBufferToDisplay();

	loadShader();

	tinter_shader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);

	glShaderSourceARB(tinter_shader, 1, shade, NULL);
	glCompileShaderARB(tinter_shader);
	tinter = glCreateProgramObjectARB();
	glAttachObjectARB(tinter, tinter_shader);
	glLinkProgramARB(tinter);
	char log[500];

	glGetProgramInfoLog(tinter,500,NULL,log);
	std::cout << log << std::endl;

	loc = glGetUniformLocationARB(tinter, "backBuffer");
	glUniform1iARB(loc, al_get_opengl_texture(backbuffer));

}

void buildSkeleton()
{
	skeleton.load("Skeleton.txt");

}

bool Inisde(float x,float y,float l,float t,float r,float b )
{
 return x > l && x < r && y > t && y < b;
}

skl::Bone* findBone(float x, float y, skl::Bone* root)
{
	float x1, y1, x2, y2;

	x1 = root->getFrameX();
	x2 = root->getFrameX();
	y1 = root->getFrameY();
	y2 = root->getFrameY();

	x1 -= 12.0f;
	y1 -= 12.0f;
	x2 += 12.0f;
	y2 += 12.0f;

	if(Inisde(x,y,x1,y1,x2,y2))
	{
		return root;
	}

	skl::Bone* result = NULL;
	for(std::list<skl::Bone>::iterator it = root->begin(); it != root->end(); ++it )
	{
		result = findBone(x,y,&(*it));
		if(result)
		{
			return result;
		}
	}

	return NULL;
}
bool inverse = false;
int fr = 0;
void renderSkeleton(skl::Bone* root)
{

	if(root->getParent())
	{
	
		al_draw_scaled_rotated_bitmap(rope,al_get_bitmap_width(rope) / 2.0f,
			0,
			root->getParent()->getFrameX(), root->getParent()->getFrameY(),0.1f,(root->getLength() * 1.1f) /
			al_get_bitmap_height(rope) ,root->getFrameAngle() - (3.1415f / 2.0f),0);
		
		al_draw_line(
			root->getParent()->getFrameX(),root->getParent()->getFrameY(),
			root->getFrameX(),root->getFrameY(),al_map_rgb(255,0,0),1.0f);
		al_draw_filled_circle(root->getFrameX(),root->getFrameY(),4.0f,al_map_rgb(50,200,0));

	}
	else
	{
			al_draw_filled_circle(root->getFrameX(),root->getFrameY(),4.0f,al_map_rgb(50,200,0));
	}

	for(std::list<skl::Bone>::iterator it = root->begin(); it != root->end(); ++it)
	{
		renderSkeleton(&(*it));
	}
}

skl::Bone* boneUnderMouse = NULL;
int mouseX = 0;
int mouseY = 0;
int startX = 0;
int startY = 0;
float startAngle;
float realStartAngle;

float mouseXF;
float mouseYF;

float dot(float aX, float aY, float bX, float bY)
{
	return ((aX * bX) + (aY * bY));
}
float dots(float aX, float aY, float bX, float bY)
{
	return ((aX * bX) - (aY * bY));
}


 float SimplifyAngle(float angle)
{
	angle = fmod(angle,2.0f * 3.141592f);

	if( angle < -3.141592f )
		angle += (2.0f * 3.141592);
	else if( angle > 3.141592f )
		angle -= (2.0f * 3.141592f);
	return angle;
}
 void render();
 void inverseKinematics(float targetX, float targetY, skl::Bone* targetBone)
 {

	 std::string stopBone = "ROOT";
	 //===
	 // Track the end effector position (the final bone)
	 double endX = targetBone->getFrameX();
	 double endY = targetBone->getFrameY();

	 //===
	 // Perform CCD on the bones by optimizing each bone in a loop 
	 // from the final bone to the root bone
	 bool modifiedBones = false;

	 while(targetBone->getName() != stopBone)
	 {
		 // Get the vector from the current bone to the end effector position.
		 double curToEndX = endX - targetBone->getParent()->getFrameX();
		 double curToEndY = endY - targetBone->getParent()->getFrameY();
		 double curToEndMag = sqrt( curToEndX*curToEndX + curToEndY*curToEndY );

		 // Get the vector from the current bone to the target position.
		 double curToTargetX = targetX - targetBone->getParent()->getFrameX();
		 double curToTargetY = targetY - targetBone->getParent()->getFrameY();
		 double curToTargetMag = sqrt(   curToTargetX*curToTargetX
			 + curToTargetY*curToTargetY );

		 // Get rotation to place the end effector on the line from the current
		 // joint position to the target position.
		 double cosRotAng;
		 double sinRotAng;
		 double endTargetMag = (curToEndMag*curToTargetMag);
		 if( endTargetMag <= 0.00001f )
		 {
			 cosRotAng = 1.0f;
			 sinRotAng = 0.0f;
		 }
		 else
		 {
			 cosRotAng = (curToEndX*curToTargetX + curToEndY*curToTargetY) / endTargetMag;
			 sinRotAng = (curToEndX*curToTargetY - curToEndY*curToTargetX) / endTargetMag;
		 }

		 // Clamp the cosine into range when computing the angle (might be out of range
		 // due to floating point error).
		 double rotAng = acosf( max(-1.0f, min(1.0f,cosRotAng) ) );
		 if( sinRotAng < 0.0f )
			 rotAng = -rotAng;

		 if(targetBone->getName() == "RFoot")
		 {
			 float a = SimplifyAngle(targetBone->getAngle()) + SimplifyAngle(rotAng) > 3.14f;
				 if (a > 3.0 && a <= 3.14159)
					 a = 3.0;
				 else if (a > 3.14159 && a < 0.0)
					 a = 0.0;

				 rotAng = a - SimplifyAngle(targetBone->getAngle());

		 }
		 // Rotate the end effector position.
		 endX = targetBone->getParent()->getFrameX() + cosRotAng*curToEndX - sinRotAng*curToEndY;
		 endY = targetBone->getParent()->getFrameY() + sinRotAng*curToEndX + cosRotAng*curToEndY;

		 // Rotate the current bone in local space (this value is output to the user)
		 targetBone->setAngle(SimplifyAngle(targetBone->getAngle()) + SimplifyAngle(rotAng));

		 // Check for termination
		 double endToTargetX = (targetX-endX);
		 double endToTargetY = (targetY-endY);
	

		 // Track if the arc length that we moved the end effector was
		 // a nontrivial distance.
		 if( !modifiedBones && fabs(rotAng)*curToEndMag > 0.0001f )
		 {
			 modifiedBones = true;
		 }

		 targetBone = targetBone->getParent();
	 }

	 
 }

void render()
{


	al_set_target_bitmap(backbuffer);

     double now, diff;
 
      now = al_get_time();
      diff = now - start;
      start = now;
      ratio += diff * 0.5 * dir;
      if (dir < 0 && ratio < 0) {
         ratio = 0;
         dir = -dir;
      }
      else if (dir > 0 && ratio > 1) {
         ratio = 1;
         dir = -dir;
      }

	  al_clear_to_color(al_map_rgb(240,240,240));

	  skeleton.processAnimation();
	  skeleton.updateBones();

	  renderSkeleton(skeleton.getRoot());

     glUseProgramObjectARB(tinter);

    al_set_target_bitmap(al_get_backbuffer(al_get_current_display()));
	al_draw_bitmap(backbuffer,0,0,0);
	 glUseProgramObjectARB(0);
al_flip_display();

	  


}


int main(int argc, char *argv[])

{
	initializeAllegro();
	buildSkeleton();

	glUseProgramObjectARB(tinter);
	loc = glGetUniformLocationARB(tinter, "resolution");
	glUniform2fARB(loc, (float)al_get_display_width(al_get_current_display()),
		(float)al_get_display_height(al_get_current_display()));

	start = al_get_time();

	bool needRedraw = true;
	// Start the event queue to handle keyboard input, mouse and our timer
	
	al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE*)al_get_keyboard_event_source());
	al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE*)al_get_mouse_event_source());
	al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE*)timer);
	al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE*)display);

	while(!done) {
	
		// Block until an event enters the queue
		al_wait_for_event(queue, &event);

		//Handle rendering and logic
		if (needRedraw && al_event_queue_is_empty(queue)) {
			render();
			

			needRedraw = false;
		}

		
		switch(event.type) {
		
	case ALLEGRO_EVENT_TIMER:
		if(event.timer.source == timer)
		{

			needRedraw = true;
		}
		
		break;
	case ALLEGRO_EVENT_DISPLAY_RESIZE:

		al_acknowledge_resize(event.display.source);
		resizeBackBufferToDisplay();
		al_set_target_bitmap(backbuffer);

		double now, diff;

		now = al_get_time();
		diff = now - start;
		start = now;
		ratio += diff * 0.5 * dir;
		if (dir < 0 && ratio < 0) {
			ratio = 0;
			dir = -dir;
		}
		else if (dir > 0 && ratio > 1) {
			ratio = 1;
			dir = -dir;
		}

		al_clear_to_color(al_map_rgb(240,240,240));

		skeleton.processAnimation();
		skeleton.updateBones();

		renderSkeleton(skeleton.getRoot());



		al_set_target_bitmap(al_get_backbuffer(al_get_current_display()));

		glUseProgramObjectARB(tinter);
		loc = glGetUniformLocationARB(tinter, "resolution");
		glUniform2fARB(loc, (float)al_get_display_width(al_get_current_display()),
			(float)al_get_display_height(al_get_current_display()));

		al_draw_bitmap(backbuffer,0,0,0);
		glUseProgramObjectARB(0);
		al_flip_display();

		
		break;
	case ALLEGRO_EVENT_DISPLAY_SWITCH_IN:
		resizeBackBufferToDisplay();
		break;
	case ALLEGRO_EVENT_MOUSE_BUTTON_DOWN:
		mouseX = event.mouse.x;
		mouseY = event.mouse.y;
		startX = mouseX;
		startY = mouseY;
		boneUnderMouse = findBone((float)mouseX,(float)mouseY,skeleton.getRoot());
		if(boneUnderMouse)
		{
			if(boneUnderMouse->getParent())
			{
				startX = boneUnderMouse->getParent()->getFrameX();
				startY = boneUnderMouse->getParent()->getFrameY();
			}
			startAngle = boneUnderMouse->getAngle();
			realStartAngle = boneUnderMouse->getFrameAngle();
		}

	
		break;
	case ALLEGRO_EVENT_MOUSE_AXES:
		
		

		if(boneUnderMouse)
		{
			/*boneUnderMouse->setAngle(boneUnderMouse->getAngle() - boneUnderMouse->getFrameAngle() + (atan2((float)startY - 
				event.mouse.y,startX - event.mouse.x)) + 3.1415f );*/
			solver.solve(
				&skeleton,boneUnderMouse,(float)event.mouse.x,(float)event.mouse.y);
			skeleton.updateBones();
			//skeleton.save("Skeleton.txt");
		}
		mouseXF = (float)event.mouse.x / (float)(al_get_display_width(al_get_current_display()) + 1.0f);
		mouseYF = (float)event.mouse.y / (float)(al_get_display_height(al_get_current_display()) + 1.0f);
		glUseProgramObjectARB(tinter);
		loc = glGetUniformLocationARB(tinter,"mouse");
		glUniform2fARB(loc,(float)event.mouse.x,(float)event.mouse.y / (float)al_get_display_height(al_get_current_display()));

	glUseProgramObjectARB(0);
		break;
	case ALLEGRO_EVENT_MOUSE_BUTTON_UP:
	boneUnderMouse = NULL;
		break;
	case ALLEGRO_EVENT_DISPLAY_CLOSE:
		return 0;
		break;
		}
	}

	return 0;
}
