#ifndef SKALE_SKELETON_HPP
#define SKALE_SKELETON_HPP
#include "SKALE/platform.hpp"
#include "SKALE/Bone.hpp"
#include <map>
#include <vector>
namespace skl
{
	class Skeleton
	{
		Bone root;
		std::map<std::string,Bone*> bones;
		int boneAddedCount;

		void _updateBones(Bone* root,float realStartX, float realStartY, float realStartAngle);
		void _processAnimation(Bone* root);
		bool _getLinesFromFile(const std::string& fileName,
			std::vector<std::string>& lines );
		bool _sortLinesByLevel(std::vector<std::string>& lines,
			std::vector<std::pair<int,std::string*> >& sortedList);
		void _makeBonesFromSortedList(std::vector<std::pair<int,std::string*> >& sortedList);
	public:
		Skeleton(void);
		bool contains(const std::string& name) const;
		Bone* add(float x, float y, float angle, float length, float minAngle, float maxAngle,
			const std::string& name, Bone* parent = NULL);
		bool remove(Bone* bone);
		int count() const;
		Bone* getRoot();
		Bone* getByName(const std::string& name);
		void updateBones();
		void renameBone(const std::string& oldName, const std::string& newName);
		void renameBone(Bone* bone, const std::string& newName);
		int findLevel(const Bone* bone) const;
		bool save(const std::string& fileName) const;
		bool load(const std::string& fileName);
		void setPosition(float x, float y);
		void setAngle(float angle);
		void processAnimation();
		virtual ~Skeleton(void);
	};
}
#endif

