#include "KeyFrame.hpp"
#include "math.h"

KeyFrame::KeyFrame( float value, size_t frame )
: mValue(fmod(value,6.283f)),mFrame(frame)
{

}

KeyFrame::~KeyFrame(void)
{
}

const float& KeyFrame::getValue() const
{
	return mValue;
}


const size_t& KeyFrame::getFrame() const
{
	return mFrame;
}

bool KeyFrame::operator<( const KeyFrame& key )
{
	return getFrame() < key.getFrame();
}
