#ifndef SKALE_IK_SOLVER_HPP
#define SKALE_IK_SOLVER_HPP
#include "SKALE/platform.hpp"
#include "SKALE/Bone.hpp"

namespace skl
{
	class Skeleton;
	class IKSolver
	{
		float mSolvedRadiusSquared;
		bool mConstraints;
		bool mFixtures;
		size_t mMaxIter;
		float _simplifyAngle(float angle) const;
		float _constrainAngle(Bone* bone, float angle) const;
	public:
		IKSolver(void);
		void setSolvedRadius(float radius);
		float getSolvedRadiusSquared() const;
		void setAngleLimits(bool limited);
		bool isAngleLimited() const;
		void setStopAtFixture(bool stopping);
		bool isStoppingAtFixture() const;
		void setMaxIterations(size_t iterations);
		size_t getMaxIterations() const;
		bool solveIteration(Bone* targetBone, float targetX, float targetY) const;
		bool solve(Skeleton* skeleton,Bone* targetBone, float targetX, float targetY);
		bool solve(Skeleton* skeleton,const std::string& boneName, float targetX, float targetY);

		virtual ~IKSolver(void);
	};
}

#endif
