#ifndef SKALE_BONE_HPP
#define SKALE_BONE_HPP
#include <list>
#include <vector>
#include "SKALE/platform.hpp"
#include "SKALE/KeyFrame.hpp"
namespace skl
{
	//NOTE: This class does not do any logical verifications when setting values
	class Bone
	{
		bool mRelative;
		float mX;
		float mY;
		float mAngle; //radians
		float mMinAngle;
		float mMaxAngle;
		float mLength;
		std::string mName;
		Bone* mParent;
		std::list<Bone> children;
		std::vector<KeyFrame> mKeyFrames;
		bool mFixture;

		float mFrameX;
		float mFrameY;
		float mFrameAngle;
		size_t currentFrame;
		int currentKeyFrameIndex;
		KeyFrame* startKeyFrame;
		KeyFrame* endKeyFrame;
		int remainingInterpolationFrames;
		float curIncreaseAngle;
		int framesPerSecond;
		void interpolateIncreaseAngle();
	public:
		Bone(float x, float y, float angle, float length,
			float minAngle, float maxAngle, bool relative,
			const std::string& name, 
			Bone* parent = NULL);
		Bone* add(float x, float y, float angle, float length,
			float minAngle, float maxAngle, const std::string& name = "");
		bool remove(Bone* child);
		void clear();
		void setAngle(float angle);
		const float& getAngle() const;
		void setX(float x);
		void setY(float y);
		const float& getX() const;
		const float& getY() const;
		void set(float x, float y);
		void set(float x, float y, float angle);
		void setMinAngle(float minAngle);
		void setMaxAngle(float maxAngle);
		const float& getMinAngle() const;
		const float& getMaxAngle() const;
		void setLength(float length);
		const float& getLength() const;
		void setRelative(bool relative);
		bool isRelative() const;
		std::list<Bone>::iterator begin();
		std::list<Bone>::iterator end();
		Bone* getParent() const;
		void setName(const std::string &name);
		const std::string& getName() const;
		int count() const;
		void setFrame(float frameX, float frameY, float FrameAngle);
		const float& getFrameX() const;
		const float& getFrameY() const;
		const float& getFrameAngle() const;

		void setAsFixture(bool fixture);
		bool isFixture() const;


		void addKeyFrame(const KeyFrame& keyFrame);
		void addKeyFrames(const std::vector<KeyFrame>& keyFrames);
		void resetAnimation();
		void processAnimation();
		
		virtual ~Bone(void);
	};
}

#endif
