#include <stdio.h>
#include <list>

#define ALLEGRO_STATICLINK
#include "allegro5/allegro.h"
#include "allegro5/allegro_font.h"
#include "allegro5/allegro_ttf.h"
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>

class SPOT {

   private:

      ALLEGRO_BITMAP  *bmp;
      float posi_X, posi_Y, vel;

   public:

      SPOT(ALLEGRO_BITMAP *T_bmp, float T_y, float T_vel) :
      bmp    (T_bmp),
      posi_X (-100),
      posi_Y (T_y),
      vel    (T_vel){}

   ~SPOT(){

      al_destroy_bitmap(bmp);

   }

   void move(){

      al_draw_bitmap(bmp, posi_X, posi_Y, 0);

      posi_X += vel;

      if(posi_X>640) posi_X=-100;

   }

};

int main()
{
    if(!al_init())
    {
        fprintf(stderr, "Failed to initialize Allegro.\n");
        return -1;
    }

    al_init_font_addon();
    al_init_ttf_addon();
    al_init_image_addon();
    al_install_audio();
    al_init_acodec_addon();
    al_reserve_samples(1);
    al_install_keyboard();

    ALLEGRO_DISPLAY *display = NULL;
    display = al_create_display(640,480);
    ALLEGRO_BITMAP  *Obj_Bmp = al_load_bitmap("spot.png");
    ALLEGRO_BITMAP  *Obj_Bmp2= al_load_bitmap("spot.png");
    ALLEGRO_FONT    *font    = al_load_ttf_font("consola.ttf",72,0 );
    ALLEGRO_FONT    *font2    = al_load_ttf_font("consola.ttf",72,0 );
    ALLEGRO_FONT    *font3    = al_load_ttf_font("consola.ttf",72,0 );
    ALLEGRO_FONT    *font4    = al_load_ttf_font("consola.ttf",72,0 );
    ALLEGRO_FONT    *font5    = al_load_ttf_font("consola.ttf",72,0 );
    ALLEGRO_KEYBOARD_STATE keyboard;
    ALLEGRO_SAMPLE *beep = al_load_sample("beep.ogg");

    //Obj_Bmp = al_load_bitmap("spot.png");


    std::list<SPOT*> Spo_List;

    for(int a=0; a<10; a++)
       Spo_List.push_back(new SPOT(Obj_Bmp, rand()%480, rand()%10+1));

    while(1){
       al_get_keyboard_state(&keyboard);

       al_clear_to_color(al_map_rgb(50,10,70));

       if(al_key_down(&keyboard, ALLEGRO_KEY_A))
       al_draw_text(font, al_map_rgba(255,255,255,255),  640/2, (480/4),ALLEGRO_ALIGN_CENTRE, "Slow Font : (!");

       else if(al_key_down(&keyboard, ALLEGRO_KEY_S))
       al_draw_text(font2, al_map_rgba(255,255,255,255), 640/2,  50+(480/4),ALLEGRO_ALIGN_CENTRE, "Slow Font : (!");

       else if(al_key_down(&keyboard, ALLEGRO_KEY_D))
       al_draw_text(font3, al_map_rgba(255,255,255,255), 640/2, 100+(480/4),ALLEGRO_ALIGN_CENTRE, "Slow Font : (!");

       else if(al_key_down(&keyboard, ALLEGRO_KEY_F))
       al_draw_text(font4, al_map_rgba(255,255,255,255), 640/2, 150+(480/4),ALLEGRO_ALIGN_CENTRE, "Slow Font : (!");

       else if(al_key_down(&keyboard, ALLEGRO_KEY_G))
       al_draw_text(font5, al_map_rgba(255,255,255,255), 640/2, 200+(480/4),ALLEGRO_ALIGN_CENTRE, "Slow Font : (!");

       else if(al_key_down(&keyboard, ALLEGRO_KEY_B))
       for(int a=0; a<10;a++)
       al_draw_bitmap(Obj_Bmp2, 200+rand()%40, 200+rand()%40, 0); // This Bitmap haven't being drawn previusly.

       else if(al_key_down(&keyboard, ALLEGRO_KEY_ESCAPE))
       break;

       for(std::list<SPOT*>::iterator it = Spo_List.begin(); it != Spo_List.end(); it++)
          (*it)->move();

       al_flip_display();

       al_rest(0.05);
       al_play_sample(beep, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, 0);


    }
    al_destroy_display(display);
    return 0;
}
