

#include <cstdio>
#include <allegro.h>

#include "Animation.hpp"



volatile int ticks = 0;
int fps = 60;
double spf = 1.0/(double)fps;

void Ticker() {
   ++ticks;
}
END_OF_FUNCTION(Ticker);



int main(int argc , char** argv) {

   if (allegro_init() != 0) {return 1;}
   if (install_keyboard() != 0) {return 1;}
   if (install_timer() != 0) {return 1;}
   
   int dcd = desktop_color_depth();
   if (!dcd) {dcd = 32;}
   set_color_depth(dcd);
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED , 640 , 480 , 0 , 0) != 0) {return 1;}
   
   bool quit = false;
   
   char buf[64];
   for (int i = 0 ; i < 64 ; ++i) {buf[i] = '\0';}
   
   SimpleAnimation a(BMP_DRAW_MASKED , FORWARD_AND_BACK_REPEAT);
   
   a.Reallocate(5 , 0.5);
   for (int i = 0 ; i < 5 ; ++i) {
      sprintf(buf , "jj_f%i.bmp" , i);
      BITMAP* bmp = load_bitmap(buf , NULL);
      if (!bmp) {quit = true;}
      a.SetBitmap(bmp , true , i);
   }


   BITMAP* buffer = create_bitmap(SCREEN_W , SCREEN_H);
   if (!buffer) {return 1;}

   clear_to_color(screen , makecol(0,0,0));
   a.DrawOn(screen , SCREEN_W/2 , SCREEN_H/2);

   install_int_ex(Ticker , BPS_TO_TIMER(fps));

   while (!quit) {
      while (ticks < 1) {rest(1);}
      double dt = spf*(double)ticks;
      ticks = 0;
      
//      printf("Logic\n");
      
      a.AdvanceFrameTime(dt);
      
      if (key[KEY_ESC]) {quit = true;}
      
//      printf("Drawing\n");
      
      clear_to_color(buffer , makecol(0,0,0));
      a.DrawOn(buffer , SCREEN_W/2 , SCREEN_H/2);
      blit(buffer , screen , 0 , 0 , 0 , 0 , buffer->w , buffer->h);
   }

   destroy_bitmap(buffer);

   return 0;
}
END_OF_MAIN()

