#include "allegro5/allegro5.h"
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_opengl.h>
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_native_dialog.h>
#include <allegro5/allegro_primitives.h>
#include "allegro5/allegro_audio.h"
#include "allegro5/allegro_ttf.h"
#include "allegro5/allegro_vorbis.h"

#include "al_shader.h"
#include <stdio.h>


/*

  This is just an example program demonstrating the use of ALLEGRO_SHADER.

  The Allegro Shader files are:

  al_shader.cpp
  al_shader_cg.cpp
  al_shader.h
*/


int main(void)
{
   ALLEGRO_DISPLAY *display;
   ALLEGRO_BITMAP *buffer;
   ALLEGRO_BITMAP *back;
   ALLEGRO_BITMAP *over;

   al_init();
   al_install_keyboard();
   al_install_mouse();
   al_init_image_addon();
   al_init_font_addon();
   al_init_ttf_addon();


   //al_set_new_display_flags(ALLEGRO_DIRECT3D);  // Try the CG shaders with both drivers.
   al_set_new_display_flags(ALLEGRO_OPENGL);  // Try GLSL support with the OpenGL drivers. CG shaders should work too.
   display = al_create_display(800, 600);
   if (!display) {printf("Display failed to create."); return -1;}


   // al_init_shader_addon must be called AFTER creating a display.
   // CG needs to create some variables, so you must call this before loading any shaders.

   if (!al_init_shader_addon()) {
     printf("Pixel shaders aren't supported.");
   }

   buffer = al_create_bitmap(800, 600);
   if (!buffer) {printf("Couldn't create a buffer."); return -1;}
   back = al_load_bitmap("data/back.png");
   if (!back) {printf("Couldn't load data/back.png."); return -1;}
   over = al_load_bitmap("data/over.png");
   if (!over) {printf("Couldn't load data/over.png."); return -1;}


   ALLEGRO_SHADER *s1;


   float time;
   time = -1;

   ALLEGRO_TIMER *Timer;
   ALLEGRO_EVENT_QUEUE *Queue;

   Timer = al_install_timer(ALLEGRO_BPS_TO_SECS(60));
   Queue = al_create_event_queue();
   al_register_event_source(Queue, (ALLEGRO_EVENT_SOURCE *)Timer);
   al_start_timer(Timer);

   //  I didn't check if everything was loaded correctly before because I was lazy.



   /*
     al_load_shader is the default method used for loading a shader program.
     Given the name, it compares the extension and loads the program.

     AL_SHADER_DEFAULT_LENGTH determines the maximun length of each line in the shader.

     Maybe I should ditch this AL_SHADER_DEFAULT_LENGTH by using a different method for reading.
   */


   //s1 = al_load_shader_as("data/test.foo", ".cgfx", AL_SHADER_DEFAULT_LENGTH);   // CG Effect shader. The extension
                                                                                 // is .foo, but it's loaded as if it
                                                                                 // was a .cgfx

   s1 = al_load_shader("data/test.cgfx", AL_SHADER_DEFAULT_LENGTH);   // CG Effect shader
   //s1 = al_load_shader("data/test.cg", AL_SHADER_DEFAULT_LENGTH);     // CG pixel shader program
   //s1 = al_load_shader("data/test.glsl", AL_SHADER_DEFAULT_LENGTH);   // GLSL fragment shader

   //s1 = al_load_shader("data/multitexture.cgfx", AL_SHADER_DEFAULT_LENGTH);
   //s1 = al_load_shader("data/multitexture.glsl", AL_SHADER_DEFAULT_LENGTH);

   // These test shaders all do the same effect, and there are some visual differences when changing from Direct3D
   // to OpenGL, but I assume this is hardware related and nothing I should worry about.

   if (!s1) {printf("Couldn't load shader #1."); return -1;}

   while (1) {
     ALLEGRO_EVENT event;
     al_wait_for_event(Queue, &event);
     if (event.type == ALLEGRO_EVENT_TIMER) {
       ALLEGRO_KEYBOARD_STATE state;
       al_get_keyboard_state(&state);
       if (al_key_down(&state, ALLEGRO_KEY_ESCAPE)) {
         break;
       }
       al_set_target_bitmap(buffer);
       al_clear_to_color(al_map_rgb(0, 0, 0));

       time += 0.02;

       if (time > ALLEGRO_PI*2) time-=ALLEGRO_PI*2;


       // Applies the shader to use for any following drawing calls.

       //al_set_shader_texture(s1, "texture_1", back);
       //al_set_shader_texture(s1, "texture_2", over);

       al_apply_shader(s1);


       // Sets the value of a float in the shader. As you can see, it doesn't matter what language the shader uses,
       // it's something as simple as this.
       al_set_shader_float(s1, "mody", time);


       al_draw_bitmap(back, 0, 0, 0);

       // Resets the use of any shaders. They shouldn't be used if they aren't needed anymore for the moment.
       al_clear_shaders();

       al_set_target_bitmap(al_get_backbuffer());

       al_clear_to_color(al_map_rgb(0, 0, 0));
       al_draw_bitmap(buffer, 0, 0, 0);
       al_flip_display();
     }
   }



   // Proper deletion of shaders is demonstrated here.
   al_delete_shader(s1);

   al_destroy_bitmap(back);
   al_destroy_bitmap(buffer);
   al_destroy_bitmap(over);
   return 0;
}
