#include "al_shader.h"
#include <Cg/cgD3D9.h>
#include <Cg/cgGL.h>
#include <stdio.h>
#include <assert.h>
#include <deque>



/* FOR TESTING */

#ifdef AL_SHADER_SUPPORT_CG

CGcontext   al_shader_cg_context;

std::deque<CGpass> al_cg_passes;


/*                CG Files                                   */



ALLEGRO_SHADER_CG_PS *i_al_create_shader_cg_ps_from_effect(char **text, int size) {
  ALLEGRO_SHADER_CG_PS *shader;
  shader = (ALLEGRO_SHADER_CG_PS *) malloc(sizeof(ALLEGRO_SHADER_CG_PS));

  char *text_array;
  text_array = (char *) malloc(sizeof(char)*AL_SHADER_DEFAULT_LENGTH*size);
  strcpy(text_array, "");
  for (int i=0; i<size; i++) {
    strcat(text_array, text[i]);
  }

  CGeffect effect;

  effect = cgCreateEffect(al_shader_cg_context, text_array, NULL);
  assert(effect);

  free(text_array);

  CGprofile al_profile;
  const char **profileOpts=NULL;

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    al_profile = cgD3D9GetLatestPixelProfile();
    profileOpts = cgD3D9GetOptimalOptions(al_profile);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    al_profile = cgGLGetLatestProfile(CG_GL_FRAGMENT);
    profileOpts = cgGLGetOptimalOptions(al_profile);
  }


  shader->program = cgCreateProgramFromEffect(effect, al_profile, al_shader_program_name, NULL);
  assert(shader->program);

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9LoadProgram(shader->program, TRUE, 0);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLLoadProgram(shader->program);
  }

  cgDestroyEffect(effect);

  return shader;
}



ALLEGRO_SHADER_CG_PS *i_al_create_shader_cg_ps(char **text, int size) {
  ALLEGRO_SHADER_CG_PS *shader;
  shader = (ALLEGRO_SHADER_CG_PS *) malloc(sizeof(ALLEGRO_SHADER_CG_PS));

  char *text_array;
  text_array = (char *) malloc(sizeof(char)*AL_SHADER_DEFAULT_LENGTH*size);
  strcpy(text_array, "");
  for (int i=0; i<size; i++) {
    strcat(text_array, text[i]);
  }


  /* Determine the best profile once a device to be set. */
  CGprofile al_profile;
  const char **profileOpts=NULL;

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    al_profile = cgD3D9GetLatestPixelProfile();
    profileOpts = cgD3D9GetOptimalOptions(al_profile);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    al_profile = cgGLGetLatestProfile(CG_GL_FRAGMENT);
    profileOpts = cgGLGetOptimalOptions(al_profile);
  }



  shader->program = cgCreateProgram(
      al_shader_cg_context,
      CG_SOURCE,
      text_array,
      al_profile,
      al_shader_program_name,
      profileOpts);

  assert(shader->program);

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9LoadProgram(shader->program, TRUE, 0);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLLoadProgram(shader->program);
  }



  free(text_array);
  return shader;
}


ALLEGRO_SHADER *al_create_shader_cg_ps(char **text, int size) {
  ALLEGRO_SHADER *shader;
  if (text == NULL) return NULL;

  shader = (ALLEGRO_SHADER *) malloc(sizeof(ALLEGRO_SHADER));
  al_clear_shader(shader);

  shader->cg_ps_shader = i_al_create_shader_cg_ps(text, size);
  return shader;
}



ALLEGRO_SHADER *al_create_shader_cg_ps_from_effect(char **text, int size) {
  ALLEGRO_SHADER *shader;
  if (text == NULL) return NULL;

  shader = (ALLEGRO_SHADER *) malloc(sizeof(ALLEGRO_SHADER));
  al_clear_shader(shader);

  shader->cg_ps_shader = i_al_create_shader_cg_ps_from_effect(text, size);
  return shader;
}




void al_apply_shader_cg_ps(ALLEGRO_SHADER_CG_PS *shader) {
  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9BindProgram(shader->program);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLBindProgram(shader->program);
    cgGLEnableProfile(cgGLGetLatestProfile(CG_GL_FRAGMENT));
  }
}



void al_delete_shader_cg_ps(ALLEGRO_SHADER_CG_PS *shader) {
  if (shader == NULL) return;

  cgDestroyProgram(shader->program);

  free(shader);
}





void al_set_shader_texture_cg_ps(ALLEGRO_SHADER_CG_PS *shader, const char *name, ALLEGRO_BITMAP *bt) {
  CGparameter param = cgGetNamedProgramParameter(shader->program, CG_PROGRAM, name);
  if (!param) {
    TRACE("Couldn't set texture %s in the CG Shader.\n", name);
    return;
  }

  /* TODO:
    Same situation like the GLSL texture problem. I get the parameter fine with cgGetNamedProgramParameter with a
    given name, and use depending on the driver cgGLSetTextureParameter or cgD3D9SetTextureParameter.
    Also, cgSetSamplerState is used to update the state of the samplers.

    I set before inmediate use of parameter setting, not deffered parameter setting, so this should work.
    But I guess it doesn't really :\
  */



  //CGparameter param = cgGetNamedProgramParameter(shader->program, CG_GLOBAL, name);
/*
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLSetTextureParameter(param, al_get_opengl_texture(bt));
    cgGLEnableTextureParameter(param);
    glBindTexture(1, al_get_opengl_texture(bt));
  }

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9SetTextureParameter(param, (IDirect3DBaseTexture9 *) al_d3d_get_video_texture(bt));
  }
  cgSetSamplerState(param);
*/
}



void al_set_shader_float_cg_ps(ALLEGRO_SHADER_CG_PS *shader, const char *name, float v) {
  CGparameter param = cgGetNamedProgramParameter(shader->program, CG_GLOBAL, name);

  if (param) cgSetParameter1f(param, v);
  else TRACE("Couldn't set float %s in the CG Shader.", name);
}




int al_init_cg_addon() {
  al_shader_cg_context = cgCreateContext();

  if (!al_shader_cg_context) {
    TRACE("Couldn't create a CG Context");
    return 0;
  }

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9SetDevice(al_d3d_get_device(al_get_current_display()));
    cgD3D9RegisterStates(al_shader_cg_context);
    //cgD3D9SetManageTextureParameters(al_shader_cg_context, CG_TRUE);
  }

  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLRegisterStates(al_shader_cg_context);
    //cgGLSetManageTextureParameters(al_shader_cg_context, CG_TRUE);
  }
  cgSetParameterSettingMode(al_shader_cg_context, CG_IMMEDIATE_PARAMETER_SETTING);

  return 1;
}



void al_clear_shaders_cg() {
  std::deque<CGpass>::iterator it;

  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9BindProgram(NULL);
  }
  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLBindProgram(NULL);
  }

  if (al_get_display_flags() & ALLEGRO_OPENGL) {
    cgGLDisableProfile(cgGLGetLatestProfile(CG_GL_FRAGMENT));
  }
}


void al_exit_shader_addon_cg() {
  cgDestroyContext(al_shader_cg_context);
  if (al_get_display_flags() & ALLEGRO_DIRECT3D) {
    cgD3D9SetDevice(NULL);
  }
}


#endif
